<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the policies for various rate types (e.g. government rates, preferred rates, etc.)
 * @subpackage Structs
 */
class RatePolicies extends AbstractStructBase
{
    /**
     * The RatePolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RatePolicy[]
     */
    public $RatePolicy;
    /**
     * Constructor method for RatePolicies
     * @uses RatePolicies::setRatePolicy()
     * @param \StructType\RatePolicy[] $ratePolicy
     */
    public function __construct(array $ratePolicy = array())
    {
        $this
            ->setRatePolicy($ratePolicy);
    }
    /**
     * Get RatePolicy value
     * @return \StructType\RatePolicy[]|null
     */
    public function getRatePolicy()
    {
        return $this->RatePolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setRatePolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRatePolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatePolicyForArrayConstraintsFromSetRatePolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePoliciesRatePolicyItem) {
            // validation for constraint: itemType
            if (!$ratePoliciesRatePolicyItem instanceof \StructType\RatePolicy) {
                $invalidValues[] = is_object($ratePoliciesRatePolicyItem) ? get_class($ratePoliciesRatePolicyItem) : sprintf('%s(%s)', gettype($ratePoliciesRatePolicyItem), var_export($ratePoliciesRatePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RatePolicy property can only contain items of type \StructType\RatePolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RatePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\RatePolicy[] $ratePolicy
     * @return \StructType\RatePolicies
     */
    public function setRatePolicy(array $ratePolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($ratePolicyArrayErrorMessage = self::validateRatePolicyForArrayConstraintsFromSetRatePolicy($ratePolicy))) {
            throw new \InvalidArgumentException($ratePolicyArrayErrorMessage, __LINE__);
        }
        $this->RatePolicy = $ratePolicy;
        return $this;
    }
    /**
     * Add item to RatePolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\RatePolicy $item
     * @return \StructType\RatePolicies
     */
    public function addToRatePolicy(\StructType\RatePolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RatePolicy) {
            throw new \InvalidArgumentException(sprintf('The RatePolicy property can only contain items of type \StructType\RatePolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RatePolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
