<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanShoulder StructType
 * Meta information extracted from the WSDL
 * - documentation: The Rate Plan Shoulder defines the allowable dates and where to take inventory during the shoulder seasons for this rate plan.
 * @subpackage Structs
 */
class RatePlanShoulder extends AbstractStructBase
{
    /**
     * The SellableProducts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $SellableProducts;
    /**
     * The ShoulderRPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this object.
     * - use: optional
     * @var string
     */
    public $ShoulderRPH;
    /**
     * The PreShoulderSellLimit
     * Meta information extracted from the WSDL
     * - documentation: Limit of inventory that can be sold before the StayDateRange. It should be understood that any stay must book at least one date in the StayDateRange.
     * - use: optional
     * @var int
     */
    public $PreShoulderSellLimit;
    /**
     * The PostShoulderSellLimit
     * Meta information extracted from the WSDL
     * - documentation: Limit of inventory that can be sold after the StayDateRange. It should be understood that any stay must book at least one date in the StayDateRange.
     * - use: optional
     * @var int
     */
    public $PostShoulderSellLimit;
    /**
     * The PreShoulderStartDate
     * Meta information extracted from the WSDL
     * - documentation: The earliest stay date that this rate plan/inventory block can be sold.
     * - use: optional
     * @var string
     */
    public $PreShoulderStartDate;
    /**
     * The PostShoulderEndDate
     * Meta information extracted from the WSDL
     * - documentation: The latest stay date that this rate plan/inventory block can be sold.
     * - use: optional
     * @var string
     */
    public $PostShoulderEndDate;
    /**
     * Constructor method for RatePlanShoulder
     * @uses RatePlanShoulder::setSellableProducts()
     * @uses RatePlanShoulder::setShoulderRPH()
     * @uses RatePlanShoulder::setPreShoulderSellLimit()
     * @uses RatePlanShoulder::setPostShoulderSellLimit()
     * @uses RatePlanShoulder::setPreShoulderStartDate()
     * @uses RatePlanShoulder::setPostShoulderEndDate()
     * @param mixed $sellableProducts
     * @param string $shoulderRPH
     * @param int $preShoulderSellLimit
     * @param int $postShoulderSellLimit
     * @param string $preShoulderStartDate
     * @param string $postShoulderEndDate
     */
    public function __construct($sellableProducts = null, $shoulderRPH = null, $preShoulderSellLimit = null, $postShoulderSellLimit = null, $preShoulderStartDate = null, $postShoulderEndDate = null)
    {
        $this
            ->setSellableProducts($sellableProducts)
            ->setShoulderRPH($shoulderRPH)
            ->setPreShoulderSellLimit($preShoulderSellLimit)
            ->setPostShoulderSellLimit($postShoulderSellLimit)
            ->setPreShoulderStartDate($preShoulderStartDate)
            ->setPostShoulderEndDate($postShoulderEndDate);
    }
    /**
     * Get SellableProducts value
     * @return mixed|null
     */
    public function getSellableProducts()
    {
        return $this->SellableProducts;
    }
    /**
     * Set SellableProducts value
     * @param mixed $sellableProducts
     * @return \StructType\RatePlanShoulder
     */
    public function setSellableProducts($sellableProducts = null)
    {
        $this->SellableProducts = $sellableProducts;
        return $this;
    }
    /**
     * Get ShoulderRPH value
     * @return string|null
     */
    public function getShoulderRPH()
    {
        return $this->ShoulderRPH;
    }
    /**
     * Set ShoulderRPH value
     * @param string $shoulderRPH
     * @return \StructType\RatePlanShoulder
     */
    public function setShoulderRPH($shoulderRPH = null)
    {
        // validation for constraint: string
        if (!is_null($shoulderRPH) && !is_string($shoulderRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shoulderRPH, true), gettype($shoulderRPH)), __LINE__);
        }
        $this->ShoulderRPH = $shoulderRPH;
        return $this;
    }
    /**
     * Get PreShoulderSellLimit value
     * @return int|null
     */
    public function getPreShoulderSellLimit()
    {
        return $this->PreShoulderSellLimit;
    }
    /**
     * Set PreShoulderSellLimit value
     * @param int $preShoulderSellLimit
     * @return \StructType\RatePlanShoulder
     */
    public function setPreShoulderSellLimit($preShoulderSellLimit = null)
    {
        // validation for constraint: int
        if (!is_null($preShoulderSellLimit) && !(is_int($preShoulderSellLimit) || ctype_digit($preShoulderSellLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preShoulderSellLimit, true), gettype($preShoulderSellLimit)), __LINE__);
        }
        $this->PreShoulderSellLimit = $preShoulderSellLimit;
        return $this;
    }
    /**
     * Get PostShoulderSellLimit value
     * @return int|null
     */
    public function getPostShoulderSellLimit()
    {
        return $this->PostShoulderSellLimit;
    }
    /**
     * Set PostShoulderSellLimit value
     * @param int $postShoulderSellLimit
     * @return \StructType\RatePlanShoulder
     */
    public function setPostShoulderSellLimit($postShoulderSellLimit = null)
    {
        // validation for constraint: int
        if (!is_null($postShoulderSellLimit) && !(is_int($postShoulderSellLimit) || ctype_digit($postShoulderSellLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postShoulderSellLimit, true), gettype($postShoulderSellLimit)), __LINE__);
        }
        $this->PostShoulderSellLimit = $postShoulderSellLimit;
        return $this;
    }
    /**
     * Get PreShoulderStartDate value
     * @return string|null
     */
    public function getPreShoulderStartDate()
    {
        return $this->PreShoulderStartDate;
    }
    /**
     * Set PreShoulderStartDate value
     * @param string $preShoulderStartDate
     * @return \StructType\RatePlanShoulder
     */
    public function setPreShoulderStartDate($preShoulderStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preShoulderStartDate) && !is_string($preShoulderStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preShoulderStartDate, true), gettype($preShoulderStartDate)), __LINE__);
        }
        $this->PreShoulderStartDate = $preShoulderStartDate;
        return $this;
    }
    /**
     * Get PostShoulderEndDate value
     * @return string|null
     */
    public function getPostShoulderEndDate()
    {
        return $this->PostShoulderEndDate;
    }
    /**
     * Set PostShoulderEndDate value
     * @param string $postShoulderEndDate
     * @return \StructType\RatePlanShoulder
     */
    public function setPostShoulderEndDate($postShoulderEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($postShoulderEndDate) && !is_string($postShoulderEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postShoulderEndDate, true), gettype($postShoulderEndDate)), __LINE__);
        }
        $this->PostShoulderEndDate = $postShoulderEndDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlanShoulder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
