<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlan StructType
 * Meta information extracted from the WSDL
 * - documentation: This indicates additional special services included in the rate plan (e.g. breakfast included). | This is a specific rate plan defined for a specific room type. | Provides the criteria to identify the rate plan to be returned.
 * @subpackage Structs
 */
class RatePlan extends RateUploadType
{
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\MarketCode[]
     */
    public $MarketCode;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: Commission associated with the RatePlan. This can be a percentage or a flat amount.
     * - minOccurs: 0
     * @var mixed
     */
    public $Commission;
    /**
     * The MethodInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\MethodInfo[]
     */
    public $MethodInfo;
    /**
     * The DaysOfWeeks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DaysOfWeeks
     */
    public $DaysOfWeeks;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: The RatePlanCode assigned for the inventory item.
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the code with which to book the item and is primarily used to exchange information with GDSs or other systems.
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * The UpgradeIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator that signifies whether a room block rate plan is available for room type upgrade.
     * - use: optional
     * @var bool
     */
    public $UpgradeIndicator;
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The DestinationSystemsCode
     * Meta information extracted from the WSDL
     * - documentation: A collection of destination system codes. These are systems for which this rate plan is targeted.
     * - minOccurs: 0
     * @var \StructType\DestinationSystemCodesType
     */
    public $DestinationSystemsCode;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - documentation: Collection of requested rate plans
     * - minOccurs: 0
     * @var \StructType\RatePlanCandidatesType
     */
    public $RatePlanCandidates;
    /**
     * The Offers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Offers
     */
    public $Offers;
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for RatePlan
     * @uses RatePlan::setMarketCode()
     * @uses RatePlan::setCommission()
     * @uses RatePlan::setMethodInfo()
     * @uses RatePlan::setDaysOfWeeks()
     * @uses RatePlan::setRatePlanCode()
     * @uses RatePlan::setBookingCode()
     * @uses RatePlan::setUpgradeIndicator()
     * @uses RatePlan::setDateRange()
     * @uses RatePlan::setDestinationSystemsCode()
     * @uses RatePlan::setRatePlanCandidates()
     * @uses RatePlan::setOffers()
     * @uses RatePlan::setHotelRef()
     * @uses RatePlan::setTPA_Extensions()
     * @param \StructType\MarketCode[] $marketCode
     * @param mixed $commission
     * @param \StructType\MethodInfo[] $methodInfo
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @param string $ratePlanCode
     * @param string $bookingCode
     * @param bool $upgradeIndicator
     * @param \StructType\DateRange $dateRange
     * @param \StructType\DestinationSystemCodesType $destinationSystemsCode
     * @param \StructType\RatePlanCandidatesType $ratePlanCandidates
     * @param \StructType\Offers $offers
     * @param \StructType\HotelRef $hotelRef
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $marketCode = array(), $commission = null, array $methodInfo = array(), \StructType\DaysOfWeeks $daysOfWeeks = null, $ratePlanCode = null, $bookingCode = null, $upgradeIndicator = null, \StructType\DateRange $dateRange = null, \StructType\DestinationSystemCodesType $destinationSystemsCode = null, \StructType\RatePlanCandidatesType $ratePlanCandidates = null, \StructType\Offers $offers = null, \StructType\HotelRef $hotelRef = null, $tPA_Extensions = null)
    {
        $this
            ->setMarketCode($marketCode)
            ->setCommission($commission)
            ->setMethodInfo($methodInfo)
            ->setDaysOfWeeks($daysOfWeeks)
            ->setRatePlanCode($ratePlanCode)
            ->setBookingCode($bookingCode)
            ->setUpgradeIndicator($upgradeIndicator)
            ->setDateRange($dateRange)
            ->setDestinationSystemsCode($destinationSystemsCode)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setOffers($offers)
            ->setHotelRef($hotelRef)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get MarketCode value
     * @return \StructType\MarketCode[]|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketCodeForArrayConstraintsFromSetMarketCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMarketCodeItem) {
            // validation for constraint: itemType
            if (!$ratePlanMarketCodeItem instanceof \StructType\MarketCode) {
                $invalidValues[] = is_object($ratePlanMarketCodeItem) ? get_class($ratePlanMarketCodeItem) : sprintf('%s(%s)', gettype($ratePlanMarketCodeItem), var_export($ratePlanMarketCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode[] $marketCode
     * @return \StructType\RatePlan
     */
    public function setMarketCode(array $marketCode = array())
    {
        // validation for constraint: array
        if ('' !== ($marketCodeArrayErrorMessage = self::validateMarketCodeForArrayConstraintsFromSetMarketCode($marketCode))) {
            throw new \InvalidArgumentException($marketCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($marketCode) && count($marketCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Add item to MarketCode value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketCode $item
     * @return \StructType\RatePlan
     */
    public function addToMarketCode(\StructType\MarketCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketCode) {
            throw new \InvalidArgumentException(sprintf('The MarketCode property can only contain items of type \StructType\MarketCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->MarketCode) && count($this->MarketCode) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->MarketCode)), __LINE__);
        }
        $this->MarketCode[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return mixed|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param mixed $commission
     * @return \StructType\RatePlan
     */
    public function setCommission($commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MethodInfo value
     * @return \StructType\MethodInfo[]|null
     */
    public function getMethodInfo()
    {
        return $this->MethodInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setMethodInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMethodInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMethodInfoForArrayConstraintsFromSetMethodInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePlanMethodInfoItem) {
            // validation for constraint: itemType
            if (!$ratePlanMethodInfoItem instanceof \StructType\MethodInfo) {
                $invalidValues[] = is_object($ratePlanMethodInfoItem) ? get_class($ratePlanMethodInfoItem) : sprintf('%s(%s)', gettype($ratePlanMethodInfoItem), var_export($ratePlanMethodInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo[] $methodInfo
     * @return \StructType\RatePlan
     */
    public function setMethodInfo(array $methodInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($methodInfoArrayErrorMessage = self::validateMethodInfoForArrayConstraintsFromSetMethodInfo($methodInfo))) {
            throw new \InvalidArgumentException($methodInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($methodInfo) && count($methodInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($methodInfo)), __LINE__);
        }
        $this->MethodInfo = $methodInfo;
        return $this;
    }
    /**
     * Add item to MethodInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MethodInfo $item
     * @return \StructType\RatePlan
     */
    public function addToMethodInfo(\StructType\MethodInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MethodInfo) {
            throw new \InvalidArgumentException(sprintf('The MethodInfo property can only contain items of type \StructType\MethodInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->MethodInfo) && count($this->MethodInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->MethodInfo)), __LINE__);
        }
        $this->MethodInfo[] = $item;
        return $this;
    }
    /**
     * Get DaysOfWeeks value
     * @return \StructType\DaysOfWeeks|null
     */
    public function getDaysOfWeeks()
    {
        return $this->DaysOfWeeks;
    }
    /**
     * Set DaysOfWeeks value
     * @param \StructType\DaysOfWeeks $daysOfWeeks
     * @return \StructType\RatePlan
     */
    public function setDaysOfWeeks(\StructType\DaysOfWeeks $daysOfWeeks = null)
    {
        $this->DaysOfWeeks = $daysOfWeeks;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlan
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RatePlan
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get UpgradeIndicator value
     * @return bool|null
     */
    public function getUpgradeIndicator()
    {
        return $this->UpgradeIndicator;
    }
    /**
     * Set UpgradeIndicator value
     * @param bool $upgradeIndicator
     * @return \StructType\RatePlan
     */
    public function setUpgradeIndicator($upgradeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($upgradeIndicator) && !is_bool($upgradeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upgradeIndicator, true), gettype($upgradeIndicator)), __LINE__);
        }
        $this->UpgradeIndicator = $upgradeIndicator;
        return $this;
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\RatePlan
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get DestinationSystemsCode value
     * @return \StructType\DestinationSystemCodesType|null
     */
    public function getDestinationSystemsCode()
    {
        return $this->DestinationSystemsCode;
    }
    /**
     * Set DestinationSystemsCode value
     * @param \StructType\DestinationSystemCodesType $destinationSystemsCode
     * @return \StructType\RatePlan
     */
    public function setDestinationSystemsCode(\StructType\DestinationSystemCodesType $destinationSystemsCode = null)
    {
        $this->DestinationSystemsCode = $destinationSystemsCode;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \StructType\RatePlanCandidatesType|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \StructType\RatePlanCandidatesType $ratePlanCandidates
     * @return \StructType\RatePlan
     */
    public function setRatePlanCandidates(\StructType\RatePlanCandidatesType $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get Offers value
     * @return \StructType\Offers|null
     */
    public function getOffers()
    {
        return $this->Offers;
    }
    /**
     * Set Offers value
     * @param \StructType\Offers $offers
     * @return \StructType\RatePlan
     */
    public function setOffers(\StructType\Offers $offers = null)
    {
        $this->Offers = $offers;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\RatePlan
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RatePlan
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
