<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RateType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RateLiteType extends AbstractStructBase
{
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: The Lite Rate contains the Base amount as well as the associated taxes.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Rate;
    /**
     * Constructor method for RateLiteType
     * @uses RateLiteType::setRate()
     * @param mixed[] $rate
     */
    public function __construct(array $rate = array())
    {
        $this
            ->setRate($rate);
    }
    /**
     * Get Rate value
     * @return mixed[]|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * This method is responsible for validating the values passed to the setRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateForArrayConstraintsFromSetRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateLiteTypeRateItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rateLiteTypeRateItem) ? get_class($rateLiteTypeRateItem) : sprintf('%s(%s)', gettype($rateLiteTypeRateItem), var_export($rateLiteTypeRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rate property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rate value
     * @throws \InvalidArgumentException
     * @param mixed[] $rate
     * @return \StructType\RateLiteType
     */
    public function setRate(array $rate = array())
    {
        // validation for constraint: array
        if ('' !== ($rateArrayErrorMessage = self::validateRateForArrayConstraintsFromSetRate($rate))) {
            throw new \InvalidArgumentException($rateArrayErrorMessage, __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Add item to Rate value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RateLiteType
     */
    public function addToRate($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Rate property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
