<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateAmountMessage StructType
 * Meta information extracted from the WSDL
 * - documentation: A rate amount message.
 * @subpackage Structs
 */
class RateAmountMessage extends RateAmountMessageType
{
    /**
     * The WarningRPH
     * Meta information extracted from the WSDL
     * - documentation: Refers to one or more warning elements giving details of one or more processing problems. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $WarningRPH;
    /**
     * Constructor method for RateAmountMessage
     * @uses RateAmountMessage::setWarningRPH()
     * @param string[] $warningRPH
     */
    public function __construct(array $warningRPH = array())
    {
        $this
            ->setWarningRPH($warningRPH);
    }
    /**
     * Get WarningRPH value
     * @return string[]|null
     */
    public function getWarningRPH()
    {
        return $this->WarningRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningRPHForArrayConstraintsFromSetWarningRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateAmountMessageWarningRPHItem) {
            // validation for constraint: itemType
            if (!is_string($rateAmountMessageWarningRPHItem)) {
                $invalidValues[] = is_object($rateAmountMessageWarningRPHItem) ? get_class($rateAmountMessageWarningRPHItem) : sprintf('%s(%s)', gettype($rateAmountMessageWarningRPHItem), var_export($rateAmountMessageWarningRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarningRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarningRPH value
     * @param string[] $warningRPH
     * @return \StructType\RateAmountMessage
     */
    public function setWarningRPH(array $warningRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($warningRPHArrayErrorMessage = self::validateWarningRPHForArrayConstraintsFromSetWarningRPH($warningRPH))) {
            throw new \InvalidArgumentException($warningRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($warningRPH) && !preg_match('/[0-9]{1,8}/', $warningRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($warningRPH, true)), __LINE__);
        }
        $this->WarningRPH = is_array($warningRPH) ? implode(' ', $warningRPH) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateAmountMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
