<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * Meta information extracted from the WSDL
 * - documentation: Rate information. | The Rate contains a collection of elements that define the amount of the rate, associated fees, additional occupant amounts as well as payment and cancellation policies. Taxes can be broken out or included within
 * the various amounts. A currency can be associated to each amount The applicable period of the the rate are indicated by the effective dates. Restrictions that may apply to that rate, such as the minimum or maximum length of stay, stay-over dates
 * (such as a Saturday night), min/max guests applicable for the rate, and age group (ex Adult) are attributes of Rate. It indicates the number of units that the quoted rate is based upon, as well as the TimeUnits type used that the rate is based upon,
 * e.g.: 3days at $100.00 per day. | An individual rate, which is a collection of amounts by guest, additional guests, fees, collection of related guarantee, cancel and payment policies, a description and the unique id to identify the rate. Rate
 * restrictions can be sent along with the rate as attributes of this rate. | Provides detailed information for how this rate is derived for this date range and inventory type. | An individual rate, which is a collection of amounts by guest, additional
 * guests, fees, collection of related guarantee, cancel and payment policies, a description and the unique id to identify the rate. Rate restrictions can be sent along with the rate as attributes of this rate. The indivual rate can also be qualified by
 * the inventory information (InventoryGroup attribute group).
 * - type: Percentage
 * - use: optional
 * @subpackage Structs
 */
class Rate extends AmountType
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Category
     */
    public $Category;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Code
     */
    public $Code;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The RateChangeIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates a rate change is applicable. When false, a rate change does not apply.
     * - use: optional
     * @var bool
     */
    public $RateChangeIndicator;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The RateMode
     * Meta information extracted from the WSDL
     * - documentation: This supports returning a type of rate (minimum, maximum, etc.) as an alternative to returning a specific rate. Refer to OpenTravel Code List Rate Mode (RMO).
     * - use: optional
     * @var string
     */
    public $RateMode;
    /**
     * The CachedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, this indicates the rate data is not real-time.
     * - use: optional
     * @var bool
     */
    public $CachedIndicator;
    /**
     * The RateSource
     * Meta information extracted from the WSDL
     * - documentation: The source from which the rate was acquired.
     * - use: optional
     * @var string
     */
    public $RateSource;
    /**
     * The RateTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the type of rate. Refer to OpenTravel Code list Rate Plan Type (RPT).
     * - use: optional
     * @var string
     */
    public $RateTypeCode;
    /**
     * The RoomPricingType
     * Meta information extracted from the WSDL
     * - documentation: Specifies how the room is priced (per night, per person, etc.).
     * - use: optional
     * @var string
     */
    public $RoomPricingType;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: This is the status of the room rate combination.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The ExtraNightIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the rate information applies to shoulder night(s).
     * - use: optional
     * @var bool
     */
    public $ExtraNightIndicator;
    /**
     * Constructor method for Rate
     * @uses Rate::setCategory()
     * @uses Rate::setCode()
     * @uses Rate::setOntologyExtension()
     * @uses Rate::setRateChangeIndicator()
     * @uses Rate::setTPA_Extensions()
     * @uses Rate::setDuration()
     * @uses Rate::setRateMode()
     * @uses Rate::setCachedIndicator()
     * @uses Rate::setRateSource()
     * @uses Rate::setRateTypeCode()
     * @uses Rate::setRoomPricingType()
     * @uses Rate::setStatus()
     * @uses Rate::setExtraNightIndicator()
     * @param \StructType\Category $category
     * @param \StructType\Code $code
     * @param mixed $ontologyExtension
     * @param bool $rateChangeIndicator
     * @param mixed $tPA_Extensions
     * @param string $duration
     * @param string $rateMode
     * @param bool $cachedIndicator
     * @param string $rateSource
     * @param string $rateTypeCode
     * @param string $roomPricingType
     * @param string $status
     * @param bool $extraNightIndicator
     */
    public function __construct(\StructType\Category $category = null, \StructType\Code $code = null, $ontologyExtension = null, $rateChangeIndicator = null, $tPA_Extensions = null, $duration = null, $rateMode = null, $cachedIndicator = null, $rateSource = null, $rateTypeCode = null, $roomPricingType = null, $status = null, $extraNightIndicator = null)
    {
        $this
            ->setCategory($category)
            ->setCode($code)
            ->setOntologyExtension($ontologyExtension)
            ->setRateChangeIndicator($rateChangeIndicator)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDuration($duration)
            ->setRateMode($rateMode)
            ->setCachedIndicator($cachedIndicator)
            ->setRateSource($rateSource)
            ->setRateTypeCode($rateTypeCode)
            ->setRoomPricingType($roomPricingType)
            ->setStatus($status)
            ->setExtraNightIndicator($extraNightIndicator);
    }
    /**
     * Get Category value
     * @return \StructType\Category|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\Category $category
     * @return \StructType\Rate
     */
    public function setCategory(\StructType\Category $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Code value
     * @return \StructType\Code|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \StructType\Code $code
     * @return \StructType\Rate
     */
    public function setCode(\StructType\Code $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Rate
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get RateChangeIndicator value
     * @return bool|null
     */
    public function getRateChangeIndicator()
    {
        return $this->RateChangeIndicator;
    }
    /**
     * Set RateChangeIndicator value
     * @param bool $rateChangeIndicator
     * @return \StructType\Rate
     */
    public function setRateChangeIndicator($rateChangeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateChangeIndicator) && !is_bool($rateChangeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateChangeIndicator, true), gettype($rateChangeIndicator)), __LINE__);
        }
        $this->RateChangeIndicator = $rateChangeIndicator;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\Rate
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Rate
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \StructType\Rate
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateMode, true), gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get CachedIndicator value
     * @return bool|null
     */
    public function getCachedIndicator()
    {
        return $this->CachedIndicator;
    }
    /**
     * Set CachedIndicator value
     * @param bool $cachedIndicator
     * @return \StructType\Rate
     */
    public function setCachedIndicator($cachedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedIndicator) && !is_bool($cachedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cachedIndicator, true), gettype($cachedIndicator)), __LINE__);
        }
        $this->CachedIndicator = $cachedIndicator;
        return $this;
    }
    /**
     * Get RateSource value
     * @return string|null
     */
    public function getRateSource()
    {
        return $this->RateSource;
    }
    /**
     * Set RateSource value
     * @param string $rateSource
     * @return \StructType\Rate
     */
    public function setRateSource($rateSource = null)
    {
        // validation for constraint: string
        if (!is_null($rateSource) && !is_string($rateSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateSource, true), gettype($rateSource)), __LINE__);
        }
        $this->RateSource = $rateSource;
        return $this;
    }
    /**
     * Get RateTypeCode value
     * @return string|null
     */
    public function getRateTypeCode()
    {
        return $this->RateTypeCode;
    }
    /**
     * Set RateTypeCode value
     * @param string $rateTypeCode
     * @return \StructType\Rate
     */
    public function setRateTypeCode($rateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateTypeCode) && !is_string($rateTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTypeCode, true), gettype($rateTypeCode)), __LINE__);
        }
        $this->RateTypeCode = $rateTypeCode;
        return $this;
    }
    /**
     * Get RoomPricingType value
     * @return string|null
     */
    public function getRoomPricingType()
    {
        return $this->RoomPricingType;
    }
    /**
     * Set RoomPricingType value
     * @uses \EnumType\PricingType::valueIsValid()
     * @uses \EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roomPricingType
     * @return \StructType\Rate
     */
    public function setRoomPricingType($roomPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingType::valueIsValid($roomPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingType', is_array($roomPricingType) ? implode(', ', $roomPricingType) : var_export($roomPricingType, true), implode(', ', \EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->RoomPricingType = $roomPricingType;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\AvailabilityStatusType::valueIsValid()
     * @uses \EnumType\AvailabilityStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Rate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AvailabilityStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExtraNightIndicator value
     * @return bool|null
     */
    public function getExtraNightIndicator()
    {
        return $this->ExtraNightIndicator;
    }
    /**
     * Set ExtraNightIndicator value
     * @param bool $extraNightIndicator
     * @return \StructType\Rate
     */
    public function setExtraNightIndicator($extraNightIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($extraNightIndicator) && !is_bool($extraNightIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extraNightIndicator, true), gettype($extraNightIndicator)), __LINE__);
        }
        $this->ExtraNightIndicator = $extraNightIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
