<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailReservationSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the summary data that identifies a reservation. This information also helps in selecting a specific reservation.
 * @subpackage Structs
 */
class RailReservationSummaryType extends AbstractStructBase
{
    /**
     * The ODInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\ODInfo[]
     */
    public $ODInfo;
    /**
     * The PassengerInfo
     * Meta information extracted from the WSDL
     * - documentation: Relevant passenger information for a reservation.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $PassengerInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The BookingReferenceID
     * Meta information extracted from the WSDL
     * - documentation: The reservation ID number or PNR locator.
     * - use: optional
     * @var string
     */
    public $BookingReferenceID;
    /**
     * The DateBooked
     * Meta information extracted from the WSDL
     * - documentation: The date the reservation booking was created.
     * - use: optional
     * @var string
     */
    public $DateBooked;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: The status of the reservation.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for RailReservationSummaryType
     * @uses RailReservationSummaryType::setODInfo()
     * @uses RailReservationSummaryType::setPassengerInfo()
     * @uses RailReservationSummaryType::setTPA_Extensions()
     * @uses RailReservationSummaryType::setBookingReferenceID()
     * @uses RailReservationSummaryType::setDateBooked()
     * @uses RailReservationSummaryType::setStatus()
     * @param \StructType\ODInfo[] $oDInfo
     * @param mixed[] $passengerInfo
     * @param mixed $tPA_Extensions
     * @param string $bookingReferenceID
     * @param string $dateBooked
     * @param string $status
     */
    public function __construct(array $oDInfo = array(), array $passengerInfo = array(), $tPA_Extensions = null, $bookingReferenceID = null, $dateBooked = null, $status = null)
    {
        $this
            ->setODInfo($oDInfo)
            ->setPassengerInfo($passengerInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setBookingReferenceID($bookingReferenceID)
            ->setDateBooked($dateBooked)
            ->setStatus($status);
    }
    /**
     * Get ODInfo value
     * @return \StructType\ODInfo[]|null
     */
    public function getODInfo()
    {
        return $this->ODInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setODInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setODInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateODInfoForArrayConstraintsFromSetODInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railReservationSummaryTypeODInfoItem) {
            // validation for constraint: itemType
            if (!$railReservationSummaryTypeODInfoItem instanceof \StructType\ODInfo) {
                $invalidValues[] = is_object($railReservationSummaryTypeODInfoItem) ? get_class($railReservationSummaryTypeODInfoItem) : sprintf('%s(%s)', gettype($railReservationSummaryTypeODInfoItem), var_export($railReservationSummaryTypeODInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ODInfo property can only contain items of type \StructType\ODInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ODInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ODInfo[] $oDInfo
     * @return \StructType\RailReservationSummaryType
     */
    public function setODInfo(array $oDInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($oDInfoArrayErrorMessage = self::validateODInfoForArrayConstraintsFromSetODInfo($oDInfo))) {
            throw new \InvalidArgumentException($oDInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($oDInfo) && count($oDInfo) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($oDInfo)), __LINE__);
        }
        $this->ODInfo = $oDInfo;
        return $this;
    }
    /**
     * Add item to ODInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ODInfo $item
     * @return \StructType\RailReservationSummaryType
     */
    public function addToODInfo(\StructType\ODInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ODInfo) {
            throw new \InvalidArgumentException(sprintf('The ODInfo property can only contain items of type \StructType\ODInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->ODInfo) && count($this->ODInfo) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->ODInfo)), __LINE__);
        }
        $this->ODInfo[] = $item;
        return $this;
    }
    /**
     * Get PassengerInfo value
     * @return mixed[]|null
     */
    public function getPassengerInfo()
    {
        return $this->PassengerInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerInfoForArrayConstraintsFromSetPassengerInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railReservationSummaryTypePassengerInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railReservationSummaryTypePassengerInfoItem) ? get_class($railReservationSummaryTypePassengerInfoItem) : sprintf('%s(%s)', gettype($railReservationSummaryTypePassengerInfoItem), var_export($railReservationSummaryTypePassengerInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $passengerInfo
     * @return \StructType\RailReservationSummaryType
     */
    public function setPassengerInfo(array $passengerInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerInfoArrayErrorMessage = self::validatePassengerInfoForArrayConstraintsFromSetPassengerInfo($passengerInfo))) {
            throw new \InvalidArgumentException($passengerInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerInfo) && count($passengerInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerInfo)), __LINE__);
        }
        $this->PassengerInfo = $passengerInfo;
        return $this;
    }
    /**
     * Add item to PassengerInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailReservationSummaryType
     */
    public function addToPassengerInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PassengerInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerInfo) && count($this->PassengerInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerInfo)), __LINE__);
        }
        $this->PassengerInfo[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RailReservationSummaryType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return string|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param string $bookingReferenceID
     * @return \StructType\RailReservationSummaryType
     */
    public function setBookingReferenceID($bookingReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReferenceID) && !is_string($bookingReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReferenceID, true), gettype($bookingReferenceID)), __LINE__);
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get DateBooked value
     * @return string|null
     */
    public function getDateBooked()
    {
        return $this->DateBooked;
    }
    /**
     * Set DateBooked value
     * @param string $dateBooked
     * @return \StructType\RailReservationSummaryType
     */
    public function setDateBooked($dateBooked = null)
    {
        // validation for constraint: string
        if (!is_null($dateBooked) && !is_string($dateBooked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateBooked, true), gettype($dateBooked)), __LINE__);
        }
        $this->DateBooked = $dateBooked;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\TransactionStatusType::valueIsValid()
     * @uses \EnumType\TransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\RailReservationSummaryType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatusType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionStatusType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TransactionStatusType::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailReservationSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
