<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: To retrieve a rail reservation when the booking reference is not known by specifying point of sale, train, traveler or booking/departure date and time criteria.
 * @subpackage Structs
 */
class RailReadRequest extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: Used to request a list of reservations made by specified travel agent, ERSP, booking channel, etc.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The Train
     * Meta information extracted from the WSDL
     * - documentation: Used to retrieve reservations based on the Network Code of Train Operator, or specific Train that was booked.
     * - minOccurs: 0
     * @var \StructType\TrainQueryType
     */
    public $Train;
    /**
     * The Traveler
     * Meta information extracted from the WSDL
     * - documentation: Used to retrieve reservation(s) based on known traveler information.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Traveler;
    /**
     * The BookingDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingDateTime
     */
    public $BookingDateTime;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DepartureDateTime
     */
    public $DepartureDateTime;
    /**
     * Constructor method for RailReadRequest
     * @uses RailReadRequest::setPOS()
     * @uses RailReadRequest::setTrain()
     * @uses RailReadRequest::setTraveler()
     * @uses RailReadRequest::setBookingDateTime()
     * @uses RailReadRequest::setDepartureDateTime()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\TrainQueryType $train
     * @param \StructType\PersonNameType $traveler
     * @param \StructType\BookingDateTime $bookingDateTime
     * @param \StructType\DepartureDateTime $departureDateTime
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\TrainQueryType $train = null, \StructType\PersonNameType $traveler = null, \StructType\BookingDateTime $bookingDateTime = null, \StructType\DepartureDateTime $departureDateTime = null)
    {
        $this
            ->setPOS($pOS)
            ->setTrain($train)
            ->setTraveler($traveler)
            ->setBookingDateTime($bookingDateTime)
            ->setDepartureDateTime($departureDateTime);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\RailReadRequest
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Train value
     * @return \StructType\TrainQueryType|null
     */
    public function getTrain()
    {
        return $this->Train;
    }
    /**
     * Set Train value
     * @param \StructType\TrainQueryType $train
     * @return \StructType\RailReadRequest
     */
    public function setTrain(\StructType\TrainQueryType $train = null)
    {
        $this->Train = $train;
        return $this;
    }
    /**
     * Get Traveler value
     * @return \StructType\PersonNameType|null
     */
    public function getTraveler()
    {
        return $this->Traveler;
    }
    /**
     * Set Traveler value
     * @param \StructType\PersonNameType $traveler
     * @return \StructType\RailReadRequest
     */
    public function setTraveler(\StructType\PersonNameType $traveler = null)
    {
        $this->Traveler = $traveler;
        return $this;
    }
    /**
     * Get BookingDateTime value
     * @return \StructType\BookingDateTime|null
     */
    public function getBookingDateTime()
    {
        return $this->BookingDateTime;
    }
    /**
     * Set BookingDateTime value
     * @param \StructType\BookingDateTime $bookingDateTime
     * @return \StructType\RailReadRequest
     */
    public function setBookingDateTime(\StructType\BookingDateTime $bookingDateTime = null)
    {
        $this->BookingDateTime = $bookingDateTime;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return \StructType\DepartureDateTime|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param \StructType\DepartureDateTime $departureDateTime
     * @return \StructType\RailReadRequest
     */
    public function setDepartureDateTime(\StructType\DepartureDateTime $departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
