<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailRateQualifyingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines rate qualifying information such as travel purpose, promotion codes and discount types that may affect the fare.
 * @subpackage Structs
 */
class RailRateQualifyingType extends AbstractStructBase
{
    /**
     * The TravelPurpose
     * Meta information extracted from the WSDL
     * - documentation: The travel purpose for the passenger.
     * - minOccurs: 0
     * @var mixed
     */
    public $TravelPurpose;
    /**
     * The DiscountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountType
     */
    public $DiscountType;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Promotion code is the identifier used by the host to link directly with a specific named advertising campaign.
     * - use: optional
     * @var string
     */
    public $PromotionCode;
    /**
     * Constructor method for RailRateQualifyingType
     * @uses RailRateQualifyingType::setTravelPurpose()
     * @uses RailRateQualifyingType::setDiscountType()
     * @uses RailRateQualifyingType::setPromotionCode()
     * @param mixed $travelPurpose
     * @param \StructType\DiscountType $discountType
     * @param string $promotionCode
     */
    public function __construct($travelPurpose = null, \StructType\DiscountType $discountType = null, $promotionCode = null)
    {
        $this
            ->setTravelPurpose($travelPurpose)
            ->setDiscountType($discountType)
            ->setPromotionCode($promotionCode);
    }
    /**
     * Get TravelPurpose value
     * @return mixed|null
     */
    public function getTravelPurpose()
    {
        return $this->TravelPurpose;
    }
    /**
     * Set TravelPurpose value
     * @param mixed $travelPurpose
     * @return \StructType\RailRateQualifyingType
     */
    public function setTravelPurpose($travelPurpose = null)
    {
        $this->TravelPurpose = $travelPurpose;
        return $this;
    }
    /**
     * Get DiscountType value
     * @return \StructType\DiscountType|null
     */
    public function getDiscountType()
    {
        return $this->DiscountType;
    }
    /**
     * Set DiscountType value
     * @param \StructType\DiscountType $discountType
     * @return \StructType\RailRateQualifyingType
     */
    public function setDiscountType(\StructType\DiscountType $discountType = null)
    {
        $this->DiscountType = $discountType;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RailRateQualifyingType
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailRateQualifyingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
