<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPriceBreakdownType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details about the rail price, including basic fare, adjustments, discounts, ancillary charges, terms and conditions, fees and taxes.
 * @subpackage Structs
 */
class RailPriceBreakdownType extends RailFareType
{
    /**
     * The AccommodationAdjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccommodationAdjustment
     */
    public $AccommodationAdjustment;
    /**
     * The FareQualifierAdjustment
     * Meta information extracted from the WSDL
     * - documentation: Other fare qualifier adjustments.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $FareQualifierAdjustment;
    /**
     * The DiscountClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\DiscountClass[]
     */
    public $DiscountClass;
    /**
     * The AncillaryCharge
     * Meta information extracted from the WSDL
     * - documentation: Ancillary product and service charges.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AncillaryCharge;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Applicable Fee code and associated amount.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Fee;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Applicable tax code and associated amount.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Tax;
    /**
     * Constructor method for RailPriceBreakdownType
     * @uses RailPriceBreakdownType::setAccommodationAdjustment()
     * @uses RailPriceBreakdownType::setFareQualifierAdjustment()
     * @uses RailPriceBreakdownType::setDiscountClass()
     * @uses RailPriceBreakdownType::setAncillaryCharge()
     * @uses RailPriceBreakdownType::setFee()
     * @uses RailPriceBreakdownType::setTax()
     * @param \StructType\AccommodationAdjustment $accommodationAdjustment
     * @param mixed[] $fareQualifierAdjustment
     * @param \StructType\DiscountClass[] $discountClass
     * @param mixed[] $ancillaryCharge
     * @param mixed[] $fee
     * @param mixed[] $tax
     */
    public function __construct(\StructType\AccommodationAdjustment $accommodationAdjustment = null, array $fareQualifierAdjustment = array(), array $discountClass = array(), array $ancillaryCharge = array(), array $fee = array(), array $tax = array())
    {
        $this
            ->setAccommodationAdjustment($accommodationAdjustment)
            ->setFareQualifierAdjustment($fareQualifierAdjustment)
            ->setDiscountClass($discountClass)
            ->setAncillaryCharge($ancillaryCharge)
            ->setFee($fee)
            ->setTax($tax);
    }
    /**
     * Get AccommodationAdjustment value
     * @return \StructType\AccommodationAdjustment|null
     */
    public function getAccommodationAdjustment()
    {
        return $this->AccommodationAdjustment;
    }
    /**
     * Set AccommodationAdjustment value
     * @param \StructType\AccommodationAdjustment $accommodationAdjustment
     * @return \StructType\RailPriceBreakdownType
     */
    public function setAccommodationAdjustment(\StructType\AccommodationAdjustment $accommodationAdjustment = null)
    {
        $this->AccommodationAdjustment = $accommodationAdjustment;
        return $this;
    }
    /**
     * Get FareQualifierAdjustment value
     * @return mixed[]|null
     */
    public function getFareQualifierAdjustment()
    {
        return $this->FareQualifierAdjustment;
    }
    /**
     * This method is responsible for validating the values passed to the setFareQualifierAdjustment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareQualifierAdjustment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareQualifierAdjustmentForArrayConstraintsFromSetFareQualifierAdjustment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPriceBreakdownTypeFareQualifierAdjustmentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPriceBreakdownTypeFareQualifierAdjustmentItem) ? get_class($railPriceBreakdownTypeFareQualifierAdjustmentItem) : sprintf('%s(%s)', gettype($railPriceBreakdownTypeFareQualifierAdjustmentItem), var_export($railPriceBreakdownTypeFareQualifierAdjustmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareQualifierAdjustment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareQualifierAdjustment value
     * @throws \InvalidArgumentException
     * @param mixed[] $fareQualifierAdjustment
     * @return \StructType\RailPriceBreakdownType
     */
    public function setFareQualifierAdjustment(array $fareQualifierAdjustment = array())
    {
        // validation for constraint: array
        if ('' !== ($fareQualifierAdjustmentArrayErrorMessage = self::validateFareQualifierAdjustmentForArrayConstraintsFromSetFareQualifierAdjustment($fareQualifierAdjustment))) {
            throw new \InvalidArgumentException($fareQualifierAdjustmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareQualifierAdjustment) && count($fareQualifierAdjustment) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareQualifierAdjustment)), __LINE__);
        }
        $this->FareQualifierAdjustment = $fareQualifierAdjustment;
        return $this;
    }
    /**
     * Add item to FareQualifierAdjustment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPriceBreakdownType
     */
    public function addToFareQualifierAdjustment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The FareQualifierAdjustment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareQualifierAdjustment) && count($this->FareQualifierAdjustment) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareQualifierAdjustment)), __LINE__);
        }
        $this->FareQualifierAdjustment[] = $item;
        return $this;
    }
    /**
     * Get DiscountClass value
     * @return \StructType\DiscountClass[]|null
     */
    public function getDiscountClass()
    {
        return $this->DiscountClass;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountClassForArrayConstraintsFromSetDiscountClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPriceBreakdownTypeDiscountClassItem) {
            // validation for constraint: itemType
            if (!$railPriceBreakdownTypeDiscountClassItem instanceof \StructType\DiscountClass) {
                $invalidValues[] = is_object($railPriceBreakdownTypeDiscountClassItem) ? get_class($railPriceBreakdownTypeDiscountClassItem) : sprintf('%s(%s)', gettype($railPriceBreakdownTypeDiscountClassItem), var_export($railPriceBreakdownTypeDiscountClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountClass property can only contain items of type \StructType\DiscountClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountClass value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountClass[] $discountClass
     * @return \StructType\RailPriceBreakdownType
     */
    public function setDiscountClass(array $discountClass = array())
    {
        // validation for constraint: array
        if ('' !== ($discountClassArrayErrorMessage = self::validateDiscountClassForArrayConstraintsFromSetDiscountClass($discountClass))) {
            throw new \InvalidArgumentException($discountClassArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($discountClass) && count($discountClass) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($discountClass)), __LINE__);
        }
        $this->DiscountClass = $discountClass;
        return $this;
    }
    /**
     * Add item to DiscountClass value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountClass $item
     * @return \StructType\RailPriceBreakdownType
     */
    public function addToDiscountClass(\StructType\DiscountClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountClass) {
            throw new \InvalidArgumentException(sprintf('The DiscountClass property can only contain items of type \StructType\DiscountClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->DiscountClass) && count($this->DiscountClass) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->DiscountClass)), __LINE__);
        }
        $this->DiscountClass[] = $item;
        return $this;
    }
    /**
     * Get AncillaryCharge value
     * @return mixed[]|null
     */
    public function getAncillaryCharge()
    {
        return $this->AncillaryCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAncillaryCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAncillaryCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAncillaryChargeForArrayConstraintsFromSetAncillaryCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPriceBreakdownTypeAncillaryChargeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPriceBreakdownTypeAncillaryChargeItem) ? get_class($railPriceBreakdownTypeAncillaryChargeItem) : sprintf('%s(%s)', gettype($railPriceBreakdownTypeAncillaryChargeItem), var_export($railPriceBreakdownTypeAncillaryChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AncillaryCharge property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AncillaryCharge value
     * @throws \InvalidArgumentException
     * @param mixed[] $ancillaryCharge
     * @return \StructType\RailPriceBreakdownType
     */
    public function setAncillaryCharge(array $ancillaryCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($ancillaryChargeArrayErrorMessage = self::validateAncillaryChargeForArrayConstraintsFromSetAncillaryCharge($ancillaryCharge))) {
            throw new \InvalidArgumentException($ancillaryChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ancillaryCharge) && count($ancillaryCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ancillaryCharge)), __LINE__);
        }
        $this->AncillaryCharge = $ancillaryCharge;
        return $this;
    }
    /**
     * Add item to AncillaryCharge value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPriceBreakdownType
     */
    public function addToAncillaryCharge($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AncillaryCharge property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AncillaryCharge) && count($this->AncillaryCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AncillaryCharge)), __LINE__);
        }
        $this->AncillaryCharge[] = $item;
        return $this;
    }
    /**
     * Get Fee value
     * @return mixed[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPriceBreakdownTypeFeeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPriceBreakdownTypeFeeItem) ? get_class($railPriceBreakdownTypeFeeItem) : sprintf('%s(%s)', gettype($railPriceBreakdownTypeFeeItem), var_export($railPriceBreakdownTypeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param mixed[] $fee
     * @return \StructType\RailPriceBreakdownType
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fee) && count($fee) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fee)), __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPriceBreakdownType
     */
    public function addToFee($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Fee) && count($this->Fee) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Fee)), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return mixed[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPriceBreakdownTypeTaxItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPriceBreakdownTypeTaxItem) ? get_class($railPriceBreakdownTypeTaxItem) : sprintf('%s(%s)', gettype($railPriceBreakdownTypeTaxItem), var_export($railPriceBreakdownTypeTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param mixed[] $tax
     * @return \StructType\RailPriceBreakdownType
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($tax) && count($tax) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPriceBreakdownType
     */
    public function addToTax($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Tax) && count($this->Tax) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Tax)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPriceBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
