<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of rail preferences.
 * @subpackage Structs
 */
class RailPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - documentation: Preferred loyalty program(s).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyPref;
    /**
     * The OperatorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\OperatorPref[]
     */
    public $OperatorPref;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\VendorPref[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\PaymentFormPref[]
     */
    public $PaymentFormPref;
    /**
     * The OriginStationPref
     * Meta information extracted from the WSDL
     * - documentation: Preferred origination station location(s) for travel.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OriginStationPref;
    /**
     * The DestinationStationPref
     * Meta information extracted from the WSDL
     * - documentation: Preferred destination station location(s) for travel.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DestinationStationPref;
    /**
     * The ConnectionPref
     * Meta information extracted from the WSDL
     * - documentation: Preferred connection location(s).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ConnectionPref;
    /**
     * The FareRestrictPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FarePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FarePref[]
     */
    public $FarePref;
    /**
     * The TrainPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\TrainPref[]
     */
    public $TrainPref;
    /**
     * The AmenityPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\AmenityPref[]
     */
    public $AmenityPref;
    /**
     * The EquipmentPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\EquipmentPref[]
     */
    public $EquipmentPref;
    /**
     * The AccommodationPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AccommodationPref[]
     */
    public $AccommodationPref;
    /**
     * The AncillaryServicePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\AncillaryServicePref[]
     */
    public $AncillaryServicePref;
    /**
     * The PassengerInfoPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\PassengerInfoPref[]
     */
    public $PassengerInfoPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - documentation: Tcket distribution preferences.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TicketDistribPref;
    /**
     * The SSR_Pref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\SSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The OSI_Pref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\OSI_Pref[]
     */
    public $OSI_Pref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RailTicketType
     * Meta information extracted from the WSDL
     * - documentation: Type of rail ticket preferred for this collection.
     * - use: optional
     * @var string
     */
    public $RailTicketType;
    /**
     * Constructor method for RailPrefType
     * @uses RailPrefType::setLoyaltyPref()
     * @uses RailPrefType::setOperatorPref()
     * @uses RailPrefType::setVendorPref()
     * @uses RailPrefType::setPaymentFormPref()
     * @uses RailPrefType::setOriginStationPref()
     * @uses RailPrefType::setDestinationStationPref()
     * @uses RailPrefType::setConnectionPref()
     * @uses RailPrefType::setFareRestrictPref()
     * @uses RailPrefType::setFarePref()
     * @uses RailPrefType::setTrainPref()
     * @uses RailPrefType::setAmenityPref()
     * @uses RailPrefType::setEquipmentPref()
     * @uses RailPrefType::setAccommodationPref()
     * @uses RailPrefType::setAncillaryServicePref()
     * @uses RailPrefType::setPassengerInfoPref()
     * @uses RailPrefType::setTicketDistribPref()
     * @uses RailPrefType::setSSR_Pref()
     * @uses RailPrefType::setOSI_Pref()
     * @uses RailPrefType::setTPA_Extensions()
     * @uses RailPrefType::setRailTicketType()
     * @param mixed[] $loyaltyPref
     * @param \StructType\OperatorPref[] $operatorPref
     * @param \StructType\VendorPref[] $vendorPref
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @param mixed[] $originStationPref
     * @param mixed[] $destinationStationPref
     * @param mixed[] $connectionPref
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @param \StructType\FarePref[] $farePref
     * @param \StructType\TrainPref[] $trainPref
     * @param \StructType\AmenityPref[] $amenityPref
     * @param \StructType\EquipmentPref[] $equipmentPref
     * @param \StructType\AccommodationPref[] $accommodationPref
     * @param \StructType\AncillaryServicePref[] $ancillaryServicePref
     * @param \StructType\PassengerInfoPref[] $passengerInfoPref
     * @param mixed[] $ticketDistribPref
     * @param \StructType\SSR_Pref[] $sSR_Pref
     * @param \StructType\OSI_Pref[] $oSI_Pref
     * @param mixed $tPA_Extensions
     * @param string $railTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $operatorPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $originStationPref = array(), array $destinationStationPref = array(), array $connectionPref = array(), array $fareRestrictPref = array(), array $farePref = array(), array $trainPref = array(), array $amenityPref = array(), array $equipmentPref = array(), array $accommodationPref = array(), array $ancillaryServicePref = array(), array $passengerInfoPref = array(), array $ticketDistribPref = array(), array $sSR_Pref = array(), array $oSI_Pref = array(), $tPA_Extensions = null, $railTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setOperatorPref($operatorPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setOriginStationPref($originStationPref)
            ->setDestinationStationPref($destinationStationPref)
            ->setConnectionPref($connectionPref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFarePref($farePref)
            ->setTrainPref($trainPref)
            ->setAmenityPref($amenityPref)
            ->setEquipmentPref($equipmentPref)
            ->setAccommodationPref($accommodationPref)
            ->setAncillaryServicePref($ancillaryServicePref)
            ->setPassengerInfoPref($passengerInfoPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setSSR_Pref($sSR_Pref)
            ->setOSI_Pref($oSI_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRailTicketType($railTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return mixed[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPrefTypeLoyaltyPrefItem) ? get_class($railPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeLoyaltyPrefItem), var_export($railPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyPref
     * @return \StructType\RailPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($loyaltyPref) && count($loyaltyPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($loyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPrefType
     */
    public function addToLoyaltyPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->LoyaltyPref) && count($this->LoyaltyPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->LoyaltyPref)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get OperatorPref value
     * @return \StructType\OperatorPref[]|null
     */
    public function getOperatorPref()
    {
        return $this->OperatorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setOperatorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperatorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperatorPrefForArrayConstraintsFromSetOperatorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeOperatorPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeOperatorPrefItem instanceof \StructType\OperatorPref) {
                $invalidValues[] = is_object($railPrefTypeOperatorPrefItem) ? get_class($railPrefTypeOperatorPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeOperatorPrefItem), var_export($railPrefTypeOperatorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperatorPref property can only contain items of type \StructType\OperatorPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperatorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorPref[] $operatorPref
     * @return \StructType\RailPrefType
     */
    public function setOperatorPref(array $operatorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($operatorPrefArrayErrorMessage = self::validateOperatorPrefForArrayConstraintsFromSetOperatorPref($operatorPref))) {
            throw new \InvalidArgumentException($operatorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($operatorPref) && count($operatorPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($operatorPref)), __LINE__);
        }
        $this->OperatorPref = $operatorPref;
        return $this;
    }
    /**
     * Add item to OperatorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorPref $item
     * @return \StructType\RailPrefType
     */
    public function addToOperatorPref(\StructType\OperatorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperatorPref) {
            throw new \InvalidArgumentException(sprintf('The OperatorPref property can only contain items of type \StructType\OperatorPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->OperatorPref) && count($this->OperatorPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->OperatorPref)), __LINE__);
        }
        $this->OperatorPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeVendorPrefItem instanceof \StructType\VendorPref) {
                $invalidValues[] = is_object($railPrefTypeVendorPrefItem) ? get_class($railPrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeVendorPrefItem), var_export($railPrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref[] $vendorPref
     * @return \StructType\RailPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($vendorPref) && count($vendorPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($vendorPref)), __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref $item
     * @return \StructType\RailPrefType
     */
    public function addToVendorPref(\StructType\VendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->VendorPref) && count($this->VendorPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->VendorPref)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \StructType\PaymentFormPref[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypePaymentFormPrefItem instanceof \StructType\PaymentFormPref) {
                $invalidValues[] = is_object($railPrefTypePaymentFormPrefItem) ? get_class($railPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($railPrefTypePaymentFormPrefItem), var_export($railPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @return \StructType\RailPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentFormPref) && count($paymentFormPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref $item
     * @return \StructType\RailPrefType
     */
    public function addToPaymentFormPref(\StructType\PaymentFormPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormPref) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentFormPref) && count($this->PaymentFormPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentFormPref)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get OriginStationPref value
     * @return mixed[]|null
     */
    public function getOriginStationPref()
    {
        return $this->OriginStationPref;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginStationPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginStationPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginStationPrefForArrayConstraintsFromSetOriginStationPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeOriginStationPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPrefTypeOriginStationPrefItem) ? get_class($railPrefTypeOriginStationPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeOriginStationPrefItem), var_export($railPrefTypeOriginStationPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginStationPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginStationPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $originStationPref
     * @return \StructType\RailPrefType
     */
    public function setOriginStationPref(array $originStationPref = array())
    {
        // validation for constraint: array
        if ('' !== ($originStationPrefArrayErrorMessage = self::validateOriginStationPrefForArrayConstraintsFromSetOriginStationPref($originStationPref))) {
            throw new \InvalidArgumentException($originStationPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($originStationPref) && count($originStationPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($originStationPref)), __LINE__);
        }
        $this->OriginStationPref = $originStationPref;
        return $this;
    }
    /**
     * Add item to OriginStationPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPrefType
     */
    public function addToOriginStationPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OriginStationPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OriginStationPref) && count($this->OriginStationPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OriginStationPref)), __LINE__);
        }
        $this->OriginStationPref[] = $item;
        return $this;
    }
    /**
     * Get DestinationStationPref value
     * @return mixed[]|null
     */
    public function getDestinationStationPref()
    {
        return $this->DestinationStationPref;
    }
    /**
     * This method is responsible for validating the values passed to the setDestinationStationPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestinationStationPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationStationPrefForArrayConstraintsFromSetDestinationStationPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeDestinationStationPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPrefTypeDestinationStationPrefItem) ? get_class($railPrefTypeDestinationStationPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeDestinationStationPrefItem), var_export($railPrefTypeDestinationStationPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DestinationStationPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DestinationStationPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $destinationStationPref
     * @return \StructType\RailPrefType
     */
    public function setDestinationStationPref(array $destinationStationPref = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationStationPrefArrayErrorMessage = self::validateDestinationStationPrefForArrayConstraintsFromSetDestinationStationPref($destinationStationPref))) {
            throw new \InvalidArgumentException($destinationStationPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($destinationStationPref) && count($destinationStationPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($destinationStationPref)), __LINE__);
        }
        $this->DestinationStationPref = $destinationStationPref;
        return $this;
    }
    /**
     * Add item to DestinationStationPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPrefType
     */
    public function addToDestinationStationPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DestinationStationPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->DestinationStationPref) && count($this->DestinationStationPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->DestinationStationPref)), __LINE__);
        }
        $this->DestinationStationPref[] = $item;
        return $this;
    }
    /**
     * Get ConnectionPref value
     * @return mixed[]|null
     */
    public function getConnectionPref()
    {
        return $this->ConnectionPref;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectionPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectionPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectionPrefForArrayConstraintsFromSetConnectionPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeConnectionPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPrefTypeConnectionPrefItem) ? get_class($railPrefTypeConnectionPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeConnectionPrefItem), var_export($railPrefTypeConnectionPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectionPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectionPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $connectionPref
     * @return \StructType\RailPrefType
     */
    public function setConnectionPref(array $connectionPref = array())
    {
        // validation for constraint: array
        if ('' !== ($connectionPrefArrayErrorMessage = self::validateConnectionPrefForArrayConstraintsFromSetConnectionPref($connectionPref))) {
            throw new \InvalidArgumentException($connectionPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($connectionPref) && count($connectionPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($connectionPref)), __LINE__);
        }
        $this->ConnectionPref = $connectionPref;
        return $this;
    }
    /**
     * Add item to ConnectionPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPrefType
     */
    public function addToConnectionPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ConnectionPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ConnectionPref) && count($this->ConnectionPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ConnectionPref)), __LINE__);
        }
        $this->ConnectionPref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRestrictPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRestrictPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeFareRestrictPrefItem instanceof \StructType\FareRestrictPref) {
                $invalidValues[] = is_object($railPrefTypeFareRestrictPrefItem) ? get_class($railPrefTypeFareRestrictPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeFareRestrictPrefItem), var_export($railPrefTypeFareRestrictPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @return \StructType\RailPrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRestrictPrefArrayErrorMessage = self::validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref($fareRestrictPref))) {
            throw new \InvalidArgumentException($fareRestrictPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareRestrictPref) && count($fareRestrictPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareRestrictPref)), __LINE__);
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref $item
     * @return \StructType\RailPrefType
     */
    public function addToFareRestrictPref(\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareRestrictPref) && count($this->FareRestrictPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareRestrictPref)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FarePref value
     * @return \StructType\FarePref[]|null
     */
    public function getFarePref()
    {
        return $this->FarePref;
    }
    /**
     * This method is responsible for validating the values passed to the setFarePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFarePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFarePrefForArrayConstraintsFromSetFarePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeFarePrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeFarePrefItem instanceof \StructType\FarePref) {
                $invalidValues[] = is_object($railPrefTypeFarePrefItem) ? get_class($railPrefTypeFarePrefItem) : sprintf('%s(%s)', gettype($railPrefTypeFarePrefItem), var_export($railPrefTypeFarePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FarePref property can only contain items of type \StructType\FarePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FarePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePref[] $farePref
     * @return \StructType\RailPrefType
     */
    public function setFarePref(array $farePref = array())
    {
        // validation for constraint: array
        if ('' !== ($farePrefArrayErrorMessage = self::validateFarePrefForArrayConstraintsFromSetFarePref($farePref))) {
            throw new \InvalidArgumentException($farePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($farePref) && count($farePref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($farePref)), __LINE__);
        }
        $this->FarePref = $farePref;
        return $this;
    }
    /**
     * Add item to FarePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePref $item
     * @return \StructType\RailPrefType
     */
    public function addToFarePref(\StructType\FarePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FarePref) {
            throw new \InvalidArgumentException(sprintf('The FarePref property can only contain items of type \StructType\FarePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FarePref) && count($this->FarePref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FarePref)), __LINE__);
        }
        $this->FarePref[] = $item;
        return $this;
    }
    /**
     * Get TrainPref value
     * @return \StructType\TrainPref[]|null
     */
    public function getTrainPref()
    {
        return $this->TrainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTrainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrainPrefForArrayConstraintsFromSetTrainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeTrainPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeTrainPrefItem instanceof \StructType\TrainPref) {
                $invalidValues[] = is_object($railPrefTypeTrainPrefItem) ? get_class($railPrefTypeTrainPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeTrainPrefItem), var_export($railPrefTypeTrainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrainPref property can only contain items of type \StructType\TrainPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainPref[] $trainPref
     * @return \StructType\RailPrefType
     */
    public function setTrainPref(array $trainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($trainPrefArrayErrorMessage = self::validateTrainPrefForArrayConstraintsFromSetTrainPref($trainPref))) {
            throw new \InvalidArgumentException($trainPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($trainPref) && count($trainPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($trainPref)), __LINE__);
        }
        $this->TrainPref = $trainPref;
        return $this;
    }
    /**
     * Add item to TrainPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainPref $item
     * @return \StructType\RailPrefType
     */
    public function addToTrainPref(\StructType\TrainPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrainPref) {
            throw new \InvalidArgumentException(sprintf('The TrainPref property can only contain items of type \StructType\TrainPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->TrainPref) && count($this->TrainPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->TrainPref)), __LINE__);
        }
        $this->TrainPref[] = $item;
        return $this;
    }
    /**
     * Get AmenityPref value
     * @return \StructType\AmenityPref[]|null
     */
    public function getAmenityPref()
    {
        return $this->AmenityPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAmenityPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmenityPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmenityPrefForArrayConstraintsFromSetAmenityPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeAmenityPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeAmenityPrefItem instanceof \StructType\AmenityPref) {
                $invalidValues[] = is_object($railPrefTypeAmenityPrefItem) ? get_class($railPrefTypeAmenityPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeAmenityPrefItem), var_export($railPrefTypeAmenityPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AmenityPref property can only contain items of type \StructType\AmenityPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AmenityPref[] $amenityPref
     * @return \StructType\RailPrefType
     */
    public function setAmenityPref(array $amenityPref = array())
    {
        // validation for constraint: array
        if ('' !== ($amenityPrefArrayErrorMessage = self::validateAmenityPrefForArrayConstraintsFromSetAmenityPref($amenityPref))) {
            throw new \InvalidArgumentException($amenityPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($amenityPref) && count($amenityPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($amenityPref)), __LINE__);
        }
        $this->AmenityPref = $amenityPref;
        return $this;
    }
    /**
     * Add item to AmenityPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AmenityPref $item
     * @return \StructType\RailPrefType
     */
    public function addToAmenityPref(\StructType\AmenityPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmenityPref) {
            throw new \InvalidArgumentException(sprintf('The AmenityPref property can only contain items of type \StructType\AmenityPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AmenityPref) && count($this->AmenityPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AmenityPref)), __LINE__);
        }
        $this->AmenityPref[] = $item;
        return $this;
    }
    /**
     * Get EquipmentPref value
     * @return \StructType\EquipmentPref[]|null
     */
    public function getEquipmentPref()
    {
        return $this->EquipmentPref;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipmentPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipmentPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentPrefForArrayConstraintsFromSetEquipmentPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeEquipmentPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeEquipmentPrefItem instanceof \StructType\EquipmentPref) {
                $invalidValues[] = is_object($railPrefTypeEquipmentPrefItem) ? get_class($railPrefTypeEquipmentPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeEquipmentPrefItem), var_export($railPrefTypeEquipmentPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquipmentPref property can only contain items of type \StructType\EquipmentPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquipmentPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentPref[] $equipmentPref
     * @return \StructType\RailPrefType
     */
    public function setEquipmentPref(array $equipmentPref = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentPrefArrayErrorMessage = self::validateEquipmentPrefForArrayConstraintsFromSetEquipmentPref($equipmentPref))) {
            throw new \InvalidArgumentException($equipmentPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($equipmentPref) && count($equipmentPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($equipmentPref)), __LINE__);
        }
        $this->EquipmentPref = $equipmentPref;
        return $this;
    }
    /**
     * Add item to EquipmentPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentPref $item
     * @return \StructType\RailPrefType
     */
    public function addToEquipmentPref(\StructType\EquipmentPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquipmentPref) {
            throw new \InvalidArgumentException(sprintf('The EquipmentPref property can only contain items of type \StructType\EquipmentPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->EquipmentPref) && count($this->EquipmentPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->EquipmentPref)), __LINE__);
        }
        $this->EquipmentPref[] = $item;
        return $this;
    }
    /**
     * Get AccommodationPref value
     * @return \StructType\AccommodationPref[]|null
     */
    public function getAccommodationPref()
    {
        return $this->AccommodationPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAccommodationPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccommodationPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccommodationPrefForArrayConstraintsFromSetAccommodationPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeAccommodationPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeAccommodationPrefItem instanceof \StructType\AccommodationPref) {
                $invalidValues[] = is_object($railPrefTypeAccommodationPrefItem) ? get_class($railPrefTypeAccommodationPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeAccommodationPrefItem), var_export($railPrefTypeAccommodationPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccommodationPref property can only contain items of type \StructType\AccommodationPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccommodationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AccommodationPref[] $accommodationPref
     * @return \StructType\RailPrefType
     */
    public function setAccommodationPref(array $accommodationPref = array())
    {
        // validation for constraint: array
        if ('' !== ($accommodationPrefArrayErrorMessage = self::validateAccommodationPrefForArrayConstraintsFromSetAccommodationPref($accommodationPref))) {
            throw new \InvalidArgumentException($accommodationPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($accommodationPref) && count($accommodationPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($accommodationPref)), __LINE__);
        }
        $this->AccommodationPref = $accommodationPref;
        return $this;
    }
    /**
     * Add item to AccommodationPref value
     * @throws \InvalidArgumentException
     * @param \StructType\AccommodationPref $item
     * @return \StructType\RailPrefType
     */
    public function addToAccommodationPref(\StructType\AccommodationPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccommodationPref) {
            throw new \InvalidArgumentException(sprintf('The AccommodationPref property can only contain items of type \StructType\AccommodationPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AccommodationPref) && count($this->AccommodationPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AccommodationPref)), __LINE__);
        }
        $this->AccommodationPref[] = $item;
        return $this;
    }
    /**
     * Get AncillaryServicePref value
     * @return \StructType\AncillaryServicePref[]|null
     */
    public function getAncillaryServicePref()
    {
        return $this->AncillaryServicePref;
    }
    /**
     * This method is responsible for validating the values passed to the setAncillaryServicePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAncillaryServicePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAncillaryServicePrefForArrayConstraintsFromSetAncillaryServicePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeAncillaryServicePrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeAncillaryServicePrefItem instanceof \StructType\AncillaryServicePref) {
                $invalidValues[] = is_object($railPrefTypeAncillaryServicePrefItem) ? get_class($railPrefTypeAncillaryServicePrefItem) : sprintf('%s(%s)', gettype($railPrefTypeAncillaryServicePrefItem), var_export($railPrefTypeAncillaryServicePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AncillaryServicePref property can only contain items of type \StructType\AncillaryServicePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AncillaryServicePref value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryServicePref[] $ancillaryServicePref
     * @return \StructType\RailPrefType
     */
    public function setAncillaryServicePref(array $ancillaryServicePref = array())
    {
        // validation for constraint: array
        if ('' !== ($ancillaryServicePrefArrayErrorMessage = self::validateAncillaryServicePrefForArrayConstraintsFromSetAncillaryServicePref($ancillaryServicePref))) {
            throw new \InvalidArgumentException($ancillaryServicePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($ancillaryServicePref) && count($ancillaryServicePref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($ancillaryServicePref)), __LINE__);
        }
        $this->AncillaryServicePref = $ancillaryServicePref;
        return $this;
    }
    /**
     * Add item to AncillaryServicePref value
     * @throws \InvalidArgumentException
     * @param \StructType\AncillaryServicePref $item
     * @return \StructType\RailPrefType
     */
    public function addToAncillaryServicePref(\StructType\AncillaryServicePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AncillaryServicePref) {
            throw new \InvalidArgumentException(sprintf('The AncillaryServicePref property can only contain items of type \StructType\AncillaryServicePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AncillaryServicePref) && count($this->AncillaryServicePref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AncillaryServicePref)), __LINE__);
        }
        $this->AncillaryServicePref[] = $item;
        return $this;
    }
    /**
     * Get PassengerInfoPref value
     * @return \StructType\PassengerInfoPref[]|null
     */
    public function getPassengerInfoPref()
    {
        return $this->PassengerInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerInfoPrefForArrayConstraintsFromSetPassengerInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypePassengerInfoPrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypePassengerInfoPrefItem instanceof \StructType\PassengerInfoPref) {
                $invalidValues[] = is_object($railPrefTypePassengerInfoPrefItem) ? get_class($railPrefTypePassengerInfoPrefItem) : sprintf('%s(%s)', gettype($railPrefTypePassengerInfoPrefItem), var_export($railPrefTypePassengerInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerInfoPref property can only contain items of type \StructType\PassengerInfoPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerInfoPref[] $passengerInfoPref
     * @return \StructType\RailPrefType
     */
    public function setPassengerInfoPref(array $passengerInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerInfoPrefArrayErrorMessage = self::validatePassengerInfoPrefForArrayConstraintsFromSetPassengerInfoPref($passengerInfoPref))) {
            throw new \InvalidArgumentException($passengerInfoPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($passengerInfoPref) && count($passengerInfoPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($passengerInfoPref)), __LINE__);
        }
        $this->PassengerInfoPref = $passengerInfoPref;
        return $this;
    }
    /**
     * Add item to PassengerInfoPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerInfoPref $item
     * @return \StructType\RailPrefType
     */
    public function addToPassengerInfoPref(\StructType\PassengerInfoPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerInfoPref) {
            throw new \InvalidArgumentException(sprintf('The PassengerInfoPref property can only contain items of type \StructType\PassengerInfoPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PassengerInfoPref) && count($this->PassengerInfoPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PassengerInfoPref)), __LINE__);
        }
        $this->PassengerInfoPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return mixed[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPrefTypeTicketDistribPrefItem) ? get_class($railPrefTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($railPrefTypeTicketDistribPrefItem), var_export($railPrefTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketDistribPref
     * @return \StructType\RailPrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ticketDistribPref) && count($ticketDistribPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ticketDistribPref)), __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPrefType
     */
    public function addToTicketDistribPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TicketDistribPref) && count($this->TicketDistribPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TicketDistribPref)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \StructType\SSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * This method is responsible for validating the values passed to the setSSR_Pref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSSR_Pref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSSR_PrefForArrayConstraintsFromSetSSR_Pref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeSSR_PrefItem instanceof \StructType\SSR_Pref) {
                $invalidValues[] = is_object($railPrefTypeSSR_PrefItem) ? get_class($railPrefTypeSSR_PrefItem) : sprintf('%s(%s)', gettype($railPrefTypeSSR_PrefItem), var_export($railPrefTypeSSR_PrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SSR_Pref property can only contain items of type \StructType\SSR_Pref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\SSR_Pref[] $sSR_Pref
     * @return \StructType\RailPrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        // validation for constraint: array
        if ('' !== ($sSR_PrefArrayErrorMessage = self::validateSSR_PrefForArrayConstraintsFromSetSSR_Pref($sSR_Pref))) {
            throw new \InvalidArgumentException($sSR_PrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($sSR_Pref) && count($sSR_Pref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($sSR_Pref)), __LINE__);
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\SSR_Pref $item
     * @return \StructType\RailPrefType
     */
    public function addToSSR_Pref(\StructType\SSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of type \StructType\SSR_Pref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SSR_Pref) && count($this->SSR_Pref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SSR_Pref)), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get OSI_Pref value
     * @return \StructType\OSI_Pref[]|null
     */
    public function getOSI_Pref()
    {
        return $this->OSI_Pref;
    }
    /**
     * This method is responsible for validating the values passed to the setOSI_Pref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOSI_Pref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOSI_PrefForArrayConstraintsFromSetOSI_Pref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPrefTypeOSI_PrefItem) {
            // validation for constraint: itemType
            if (!$railPrefTypeOSI_PrefItem instanceof \StructType\OSI_Pref) {
                $invalidValues[] = is_object($railPrefTypeOSI_PrefItem) ? get_class($railPrefTypeOSI_PrefItem) : sprintf('%s(%s)', gettype($railPrefTypeOSI_PrefItem), var_export($railPrefTypeOSI_PrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OSI_Pref property can only contain items of type \StructType\OSI_Pref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OSI_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\OSI_Pref[] $oSI_Pref
     * @return \StructType\RailPrefType
     */
    public function setOSI_Pref(array $oSI_Pref = array())
    {
        // validation for constraint: array
        if ('' !== ($oSI_PrefArrayErrorMessage = self::validateOSI_PrefForArrayConstraintsFromSetOSI_Pref($oSI_Pref))) {
            throw new \InvalidArgumentException($oSI_PrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($oSI_Pref) && count($oSI_Pref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($oSI_Pref)), __LINE__);
        }
        $this->OSI_Pref = $oSI_Pref;
        return $this;
    }
    /**
     * Add item to OSI_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\OSI_Pref $item
     * @return \StructType\RailPrefType
     */
    public function addToOSI_Pref(\StructType\OSI_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OSI_Pref) {
            throw new \InvalidArgumentException(sprintf('The OSI_Pref property can only contain items of type \StructType\OSI_Pref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OSI_Pref) && count($this->OSI_Pref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OSI_Pref)), __LINE__);
        }
        $this->OSI_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\RailPrefType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RailTicketType value
     * @return string|null
     */
    public function getRailTicketType()
    {
        return $this->RailTicketType;
    }
    /**
     * Set RailTicketType value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railTicketType
     * @return \StructType\RailPrefType
     */
    public function setRailTicketType($railTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($railTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TicketType', is_array($railTicketType) ? implode(', ', $railTicketType) : var_export($railTicketType, true), implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->RailTicketType = $railTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
