<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailPassengerCategoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Classification of passenger demographics and rate qualifying information.
 * @subpackage Structs
 */
class RailPassengerCategoryType extends AbstractStructBase
{
    /**
     * The Occupation
     * Meta information extracted from the WSDL
     * - documentation: The passenger occupation.
     * - minOccurs: 0
     * @var mixed
     */
    public $Occupation;
    /**
     * The PassengerQualifyingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\PassengerQualifyingInfo[]
     */
    public $PassengerQualifyingInfo;
    /**
     * The ADA_Requirement
     * Meta information extracted from the WSDL
     * - documentation: Passenger ADA requirements. Refer to OpenTravel Disability Feature Code (PHY) code list.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ADA_Requirement;
    /**
     * The AccompaniedByInfantInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, an infant is accompanying a passenger.
     * - use: optional
     * @var bool
     */
    public $AccompaniedByInfantInd;
    /**
     * Constructor method for RailPassengerCategoryType
     * @uses RailPassengerCategoryType::setOccupation()
     * @uses RailPassengerCategoryType::setPassengerQualifyingInfo()
     * @uses RailPassengerCategoryType::setADA_Requirement()
     * @uses RailPassengerCategoryType::setAccompaniedByInfantInd()
     * @param mixed $occupation
     * @param \StructType\PassengerQualifyingInfo[] $passengerQualifyingInfo
     * @param mixed[] $aDA_Requirement
     * @param bool $accompaniedByInfantInd
     */
    public function __construct($occupation = null, array $passengerQualifyingInfo = array(), array $aDA_Requirement = array(), $accompaniedByInfantInd = null)
    {
        $this
            ->setOccupation($occupation)
            ->setPassengerQualifyingInfo($passengerQualifyingInfo)
            ->setADA_Requirement($aDA_Requirement)
            ->setAccompaniedByInfantInd($accompaniedByInfantInd);
    }
    /**
     * Get Occupation value
     * @return mixed|null
     */
    public function getOccupation()
    {
        return $this->Occupation;
    }
    /**
     * Set Occupation value
     * @param mixed $occupation
     * @return \StructType\RailPassengerCategoryType
     */
    public function setOccupation($occupation = null)
    {
        $this->Occupation = $occupation;
        return $this;
    }
    /**
     * Get PassengerQualifyingInfo value
     * @return \StructType\PassengerQualifyingInfo[]|null
     */
    public function getPassengerQualifyingInfo()
    {
        return $this->PassengerQualifyingInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerQualifyingInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerQualifyingInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerQualifyingInfoForArrayConstraintsFromSetPassengerQualifyingInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerCategoryTypePassengerQualifyingInfoItem) {
            // validation for constraint: itemType
            if (!$railPassengerCategoryTypePassengerQualifyingInfoItem instanceof \StructType\PassengerQualifyingInfo) {
                $invalidValues[] = is_object($railPassengerCategoryTypePassengerQualifyingInfoItem) ? get_class($railPassengerCategoryTypePassengerQualifyingInfoItem) : sprintf('%s(%s)', gettype($railPassengerCategoryTypePassengerQualifyingInfoItem), var_export($railPassengerCategoryTypePassengerQualifyingInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerQualifyingInfo property can only contain items of type \StructType\PassengerQualifyingInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerQualifyingInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerQualifyingInfo[] $passengerQualifyingInfo
     * @return \StructType\RailPassengerCategoryType
     */
    public function setPassengerQualifyingInfo(array $passengerQualifyingInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerQualifyingInfoArrayErrorMessage = self::validatePassengerQualifyingInfoForArrayConstraintsFromSetPassengerQualifyingInfo($passengerQualifyingInfo))) {
            throw new \InvalidArgumentException($passengerQualifyingInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($passengerQualifyingInfo) && count($passengerQualifyingInfo) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($passengerQualifyingInfo)), __LINE__);
        }
        $this->PassengerQualifyingInfo = $passengerQualifyingInfo;
        return $this;
    }
    /**
     * Add item to PassengerQualifyingInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerQualifyingInfo $item
     * @return \StructType\RailPassengerCategoryType
     */
    public function addToPassengerQualifyingInfo(\StructType\PassengerQualifyingInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerQualifyingInfo) {
            throw new \InvalidArgumentException(sprintf('The PassengerQualifyingInfo property can only contain items of type \StructType\PassengerQualifyingInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PassengerQualifyingInfo) && count($this->PassengerQualifyingInfo) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PassengerQualifyingInfo)), __LINE__);
        }
        $this->PassengerQualifyingInfo[] = $item;
        return $this;
    }
    /**
     * Get ADA_Requirement value
     * @return mixed[]|null
     */
    public function getADA_Requirement()
    {
        return $this->ADA_Requirement;
    }
    /**
     * This method is responsible for validating the values passed to the setADA_Requirement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setADA_Requirement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateADA_RequirementForArrayConstraintsFromSetADA_Requirement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railPassengerCategoryTypeADA_RequirementItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railPassengerCategoryTypeADA_RequirementItem) ? get_class($railPassengerCategoryTypeADA_RequirementItem) : sprintf('%s(%s)', gettype($railPassengerCategoryTypeADA_RequirementItem), var_export($railPassengerCategoryTypeADA_RequirementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ADA_Requirement property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ADA_Requirement value
     * @throws \InvalidArgumentException
     * @param mixed[] $aDA_Requirement
     * @return \StructType\RailPassengerCategoryType
     */
    public function setADA_Requirement(array $aDA_Requirement = array())
    {
        // validation for constraint: array
        if ('' !== ($aDA_RequirementArrayErrorMessage = self::validateADA_RequirementForArrayConstraintsFromSetADA_Requirement($aDA_Requirement))) {
            throw new \InvalidArgumentException($aDA_RequirementArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($aDA_Requirement) && count($aDA_Requirement) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($aDA_Requirement)), __LINE__);
        }
        $this->ADA_Requirement = $aDA_Requirement;
        return $this;
    }
    /**
     * Add item to ADA_Requirement value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailPassengerCategoryType
     */
    public function addToADA_Requirement($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ADA_Requirement property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->ADA_Requirement) && count($this->ADA_Requirement) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->ADA_Requirement)), __LINE__);
        }
        $this->ADA_Requirement[] = $item;
        return $this;
    }
    /**
     * Get AccompaniedByInfantInd value
     * @return bool|null
     */
    public function getAccompaniedByInfantInd()
    {
        return $this->AccompaniedByInfantInd;
    }
    /**
     * Set AccompaniedByInfantInd value
     * @param bool $accompaniedByInfantInd
     * @return \StructType\RailPassengerCategoryType
     */
    public function setAccompaniedByInfantInd($accompaniedByInfantInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($accompaniedByInfantInd) && !is_bool($accompaniedByInfantInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accompaniedByInfantInd, true), gettype($accompaniedByInfantInd)), __LINE__);
        }
        $this->AccompaniedByInfantInd = $accompaniedByInfantInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailPassengerCategoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
