<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailChargesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines a collection of individual charges associated with the rail journey.
 * @subpackage Structs
 */
class RailChargesType extends AbstractStructBase
{
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: Contains a total of the base amounts and an estimated total when all taxes and fees are applied
     * - minOccurs: 0
     * @var mixed
     */
    public $Total;
    /**
     * The Charges
     * @var \StructType\Charges
     */
    public $Charges;
    /**
     * Constructor method for RailChargesType
     * @uses RailChargesType::setTotal()
     * @uses RailChargesType::setCharges()
     * @param mixed $total
     * @param \StructType\Charges $charges
     */
    public function __construct($total = null, \StructType\Charges $charges = null)
    {
        $this
            ->setTotal($total)
            ->setCharges($charges);
    }
    /**
     * Get Total value
     * @return mixed|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param mixed $total
     * @return \StructType\RailChargesType
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Charges value
     * @return \StructType\Charges|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \StructType\Charges $charges
     * @return \StructType\RailChargesType
     */
    public function setCharges(\StructType\Charges $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailChargesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
