<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailAvailQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines criteria for a rail availability query.
 * @subpackage Structs
 */
class RailAvailQueryType extends AbstractStructBase
{
    /**
     * The AvailBaseQueryCriteria
     * Meta information extracted from the WSDL
     * - documentation: A collection of information about the locations for which availability is to be checked. It may be repeated to query availability of each individual train in multiple train segments for a specified route.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $AvailBaseQueryCriteria;
    /**
     * The PassengerType
     * Meta information extracted from the WSDL
     * - documentation: Specify passenger type/category.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PassengerType;
    /**
     * The ReturnInfo
     * Meta information extracted from the WSDL
     * - documentation: Indicates the date and time search criteria for the return journey.
     * - minOccurs: 0
     * @var mixed
     */
    public $ReturnInfo;
    /**
     * The RailPrefs
     * Meta information extracted from the WSDL
     * - documentation: Specifies the preferences for the availability request.
     * - minOccurs: 0
     * @var mixed
     */
    public $RailPrefs;
    /**
     * Constructor method for RailAvailQueryType
     * @uses RailAvailQueryType::setAvailBaseQueryCriteria()
     * @uses RailAvailQueryType::setPassengerType()
     * @uses RailAvailQueryType::setReturnInfo()
     * @uses RailAvailQueryType::setRailPrefs()
     * @param mixed[] $availBaseQueryCriteria
     * @param mixed[] $passengerType
     * @param mixed $returnInfo
     * @param mixed $railPrefs
     */
    public function __construct(array $availBaseQueryCriteria = array(), array $passengerType = array(), $returnInfo = null, $railPrefs = null)
    {
        $this
            ->setAvailBaseQueryCriteria($availBaseQueryCriteria)
            ->setPassengerType($passengerType)
            ->setReturnInfo($returnInfo)
            ->setRailPrefs($railPrefs);
    }
    /**
     * Get AvailBaseQueryCriteria value
     * @return mixed[]|null
     */
    public function getAvailBaseQueryCriteria()
    {
        return $this->AvailBaseQueryCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailBaseQueryCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailBaseQueryCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailBaseQueryCriteriaForArrayConstraintsFromSetAvailBaseQueryCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailQueryTypeAvailBaseQueryCriteriaItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railAvailQueryTypeAvailBaseQueryCriteriaItem) ? get_class($railAvailQueryTypeAvailBaseQueryCriteriaItem) : sprintf('%s(%s)', gettype($railAvailQueryTypeAvailBaseQueryCriteriaItem), var_export($railAvailQueryTypeAvailBaseQueryCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AvailBaseQueryCriteria property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AvailBaseQueryCriteria value
     * @throws \InvalidArgumentException
     * @param mixed[] $availBaseQueryCriteria
     * @return \StructType\RailAvailQueryType
     */
    public function setAvailBaseQueryCriteria(array $availBaseQueryCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($availBaseQueryCriteriaArrayErrorMessage = self::validateAvailBaseQueryCriteriaForArrayConstraintsFromSetAvailBaseQueryCriteria($availBaseQueryCriteria))) {
            throw new \InvalidArgumentException($availBaseQueryCriteriaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($availBaseQueryCriteria) && count($availBaseQueryCriteria) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($availBaseQueryCriteria)), __LINE__);
        }
        $this->AvailBaseQueryCriteria = $availBaseQueryCriteria;
        return $this;
    }
    /**
     * Add item to AvailBaseQueryCriteria value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailAvailQueryType
     */
    public function addToAvailBaseQueryCriteria($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AvailBaseQueryCriteria property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AvailBaseQueryCriteria) && count($this->AvailBaseQueryCriteria) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AvailBaseQueryCriteria)), __LINE__);
        }
        $this->AvailBaseQueryCriteria[] = $item;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return mixed[]|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerTypeForArrayConstraintsFromSetPassengerType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailQueryTypePassengerTypeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railAvailQueryTypePassengerTypeItem) ? get_class($railAvailQueryTypePassengerTypeItem) : sprintf('%s(%s)', gettype($railAvailQueryTypePassengerTypeItem), var_export($railAvailQueryTypePassengerTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerType property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerType value
     * @throws \InvalidArgumentException
     * @param mixed[] $passengerType
     * @return \StructType\RailAvailQueryType
     */
    public function setPassengerType(array $passengerType = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerTypeArrayErrorMessage = self::validatePassengerTypeForArrayConstraintsFromSetPassengerType($passengerType))) {
            throw new \InvalidArgumentException($passengerTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($passengerType) && count($passengerType) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Add item to PassengerType value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailAvailQueryType
     */
    public function addToPassengerType($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PassengerType property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PassengerType) && count($this->PassengerType) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PassengerType)), __LINE__);
        }
        $this->PassengerType[] = $item;
        return $this;
    }
    /**
     * Get ReturnInfo value
     * @return mixed|null
     */
    public function getReturnInfo()
    {
        return $this->ReturnInfo;
    }
    /**
     * Set ReturnInfo value
     * @param mixed $returnInfo
     * @return \StructType\RailAvailQueryType
     */
    public function setReturnInfo($returnInfo = null)
    {
        $this->ReturnInfo = $returnInfo;
        return $this;
    }
    /**
     * Get RailPrefs value
     * @return mixed|null
     */
    public function getRailPrefs()
    {
        return $this->RailPrefs;
    }
    /**
     * Set RailPrefs value
     * @param mixed $railPrefs
     * @return \StructType\RailAvailQueryType
     */
    public function setRailPrefs($railPrefs = null)
    {
        $this->RailPrefs = $railPrefs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailAvailQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
