<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailAvailPrefsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Accommodations and services offered on a train. | Defines information used to express traveler preferences when requesting rail avilability information.
 * @subpackage Structs
 */
class RailAvailPrefsType extends AbstractStructBase
{
    /**
     * The OperatorPref
     * Meta information extracted from the WSDL
     * - documentation: Describes any preferences in terms of the company operating the train service. Preference may reflect inclusion or exclusion.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OperatorPref;
    /**
     * The TransportModes
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\TransportModes[]
     */
    public $TransportModes;
    /**
     * The RailAmenities
     * Meta information extracted from the WSDL
     * - documentation: Passenger preferred amenities for qualifying the availability request, such as WiFi.
     * - minOccurs: 0
     * @var mixed
     */
    public $RailAmenities;
    /**
     * The ClassCodes
     * Meta information extracted from the WSDL
     * - documentation: The class of inventory controlled services available.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ClassCodes;
    /**
     * The AccommodationCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: AccommodationCategory
     * @var mixed
     */
    public $AccommodationCategory;
    /**
     * Constructor method for RailAvailPrefsType
     * @uses RailAvailPrefsType::setOperatorPref()
     * @uses RailAvailPrefsType::setTransportModes()
     * @uses RailAvailPrefsType::setRailAmenities()
     * @uses RailAvailPrefsType::setClassCodes()
     * @uses RailAvailPrefsType::setAccommodationCategory()
     * @param mixed[] $operatorPref
     * @param \StructType\TransportModes[] $transportModes
     * @param mixed $railAmenities
     * @param mixed[] $classCodes
     * @param mixed $accommodationCategory
     */
    public function __construct(array $operatorPref = array(), array $transportModes = array(), $railAmenities = null, array $classCodes = array(), $accommodationCategory = null)
    {
        $this
            ->setOperatorPref($operatorPref)
            ->setTransportModes($transportModes)
            ->setRailAmenities($railAmenities)
            ->setClassCodes($classCodes)
            ->setAccommodationCategory($accommodationCategory);
    }
    /**
     * Get OperatorPref value
     * @return mixed[]|null
     */
    public function getOperatorPref()
    {
        return $this->OperatorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setOperatorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperatorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperatorPrefForArrayConstraintsFromSetOperatorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailPrefsTypeOperatorPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railAvailPrefsTypeOperatorPrefItem) ? get_class($railAvailPrefsTypeOperatorPrefItem) : sprintf('%s(%s)', gettype($railAvailPrefsTypeOperatorPrefItem), var_export($railAvailPrefsTypeOperatorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperatorPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperatorPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $operatorPref
     * @return \StructType\RailAvailPrefsType
     */
    public function setOperatorPref(array $operatorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($operatorPrefArrayErrorMessage = self::validateOperatorPrefForArrayConstraintsFromSetOperatorPref($operatorPref))) {
            throw new \InvalidArgumentException($operatorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($operatorPref) && count($operatorPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($operatorPref)), __LINE__);
        }
        $this->OperatorPref = $operatorPref;
        return $this;
    }
    /**
     * Add item to OperatorPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailAvailPrefsType
     */
    public function addToOperatorPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OperatorPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->OperatorPref) && count($this->OperatorPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->OperatorPref)), __LINE__);
        }
        $this->OperatorPref[] = $item;
        return $this;
    }
    /**
     * Get TransportModes value
     * @return \StructType\TransportModes[]|null
     */
    public function getTransportModes()
    {
        return $this->TransportModes;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportModes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportModes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportModesForArrayConstraintsFromSetTransportModes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailPrefsTypeTransportModesItem) {
            // validation for constraint: itemType
            if (!$railAvailPrefsTypeTransportModesItem instanceof \StructType\TransportModes) {
                $invalidValues[] = is_object($railAvailPrefsTypeTransportModesItem) ? get_class($railAvailPrefsTypeTransportModesItem) : sprintf('%s(%s)', gettype($railAvailPrefsTypeTransportModesItem), var_export($railAvailPrefsTypeTransportModesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportModes property can only contain items of type \StructType\TransportModes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportModes value
     * @throws \InvalidArgumentException
     * @param \StructType\TransportModes[] $transportModes
     * @return \StructType\RailAvailPrefsType
     */
    public function setTransportModes(array $transportModes = array())
    {
        // validation for constraint: array
        if ('' !== ($transportModesArrayErrorMessage = self::validateTransportModesForArrayConstraintsFromSetTransportModes($transportModes))) {
            throw new \InvalidArgumentException($transportModesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($transportModes) && count($transportModes) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($transportModes)), __LINE__);
        }
        $this->TransportModes = $transportModes;
        return $this;
    }
    /**
     * Add item to TransportModes value
     * @throws \InvalidArgumentException
     * @param \StructType\TransportModes $item
     * @return \StructType\RailAvailPrefsType
     */
    public function addToTransportModes(\StructType\TransportModes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransportModes) {
            throw new \InvalidArgumentException(sprintf('The TransportModes property can only contain items of type \StructType\TransportModes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TransportModes) && count($this->TransportModes) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TransportModes)), __LINE__);
        }
        $this->TransportModes[] = $item;
        return $this;
    }
    /**
     * Get RailAmenities value
     * @return mixed|null
     */
    public function getRailAmenities()
    {
        return $this->RailAmenities;
    }
    /**
     * Set RailAmenities value
     * @param mixed $railAmenities
     * @return \StructType\RailAvailPrefsType
     */
    public function setRailAmenities($railAmenities = null)
    {
        $this->RailAmenities = $railAmenities;
        return $this;
    }
    /**
     * Get ClassCodes value
     * @return mixed[]|null
     */
    public function getClassCodes()
    {
        return $this->ClassCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setClassCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassCodesForArrayConstraintsFromSetClassCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAvailPrefsTypeClassCodesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($railAvailPrefsTypeClassCodesItem) ? get_class($railAvailPrefsTypeClassCodesItem) : sprintf('%s(%s)', gettype($railAvailPrefsTypeClassCodesItem), var_export($railAvailPrefsTypeClassCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClassCodes property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClassCodes value
     * @throws \InvalidArgumentException
     * @param mixed[] $classCodes
     * @return \StructType\RailAvailPrefsType
     */
    public function setClassCodes(array $classCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($classCodesArrayErrorMessage = self::validateClassCodesForArrayConstraintsFromSetClassCodes($classCodes))) {
            throw new \InvalidArgumentException($classCodesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($classCodes) && count($classCodes) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($classCodes)), __LINE__);
        }
        $this->ClassCodes = $classCodes;
        return $this;
    }
    /**
     * Add item to ClassCodes value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RailAvailPrefsType
     */
    public function addToClassCodes($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ClassCodes property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ClassCodes) && count($this->ClassCodes) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ClassCodes)), __LINE__);
        }
        $this->ClassCodes[] = $item;
        return $this;
    }
    /**
     * Get AccommodationCategory value
     * @return mixed|null
     */
    public function getAccommodationCategory()
    {
        return $this->AccommodationCategory;
    }
    /**
     * Set AccommodationCategory value
     * @param mixed $accommodationCategory
     * @return \StructType\RailAvailPrefsType
     */
    public function setAccommodationCategory($accommodationCategory = null)
    {
        $this->AccommodationCategory = $accommodationCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailAvailPrefsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
