<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailAmenityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines preferred rail amenities, including an amenity code, quantity and/or an associated preference level.
 * @subpackage Structs
 */
class RailAmenityType extends AbstractStructBase
{
    /**
     * The RailAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\RailAmenity[]
     */
    public $RailAmenity;
    /**
     * Constructor method for RailAmenityType
     * @uses RailAmenityType::setRailAmenity()
     * @param \StructType\RailAmenity[] $railAmenity
     */
    public function __construct(array $railAmenity = array())
    {
        $this
            ->setRailAmenity($railAmenity);
    }
    /**
     * Get RailAmenity value
     * @return \StructType\RailAmenity[]|null
     */
    public function getRailAmenity()
    {
        return $this->RailAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setRailAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailAmenityForArrayConstraintsFromSetRailAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $railAmenityTypeRailAmenityItem) {
            // validation for constraint: itemType
            if (!$railAmenityTypeRailAmenityItem instanceof \StructType\RailAmenity) {
                $invalidValues[] = is_object($railAmenityTypeRailAmenityItem) ? get_class($railAmenityTypeRailAmenityItem) : sprintf('%s(%s)', gettype($railAmenityTypeRailAmenityItem), var_export($railAmenityTypeRailAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RailAmenity property can only contain items of type \StructType\RailAmenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RailAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\RailAmenity[] $railAmenity
     * @return \StructType\RailAmenityType
     */
    public function setRailAmenity(array $railAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($railAmenityArrayErrorMessage = self::validateRailAmenityForArrayConstraintsFromSetRailAmenity($railAmenity))) {
            throw new \InvalidArgumentException($railAmenityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($railAmenity) && count($railAmenity) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($railAmenity)), __LINE__);
        }
        $this->RailAmenity = $railAmenity;
        return $this;
    }
    /**
     * Add item to RailAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\RailAmenity $item
     * @return \StructType\RailAmenityType
     */
    public function addToRailAmenity(\StructType\RailAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RailAmenity) {
            throw new \InvalidArgumentException(sprintf('The RailAmenity property can only contain items of type \StructType\RailAmenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->RailAmenity) && count($this->RailAmenity) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->RailAmenity)), __LINE__);
        }
        $this->RailAmenity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RailAmenityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
