<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Requests items from a booking file queue.
 * @subpackage Structs
 */
class QueueInfo extends AbstractStructBase
{
    /**
     * The Queue
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\Queue[]
     */
    public $Queue;
    /**
     * The FirstItemOnlyInd
     * Meta information extracted from the WSDL
     * - documentation: If true, only the first item on the queue is to be returned. If false, all items on the queue are to be returned.
     * @var bool
     */
    public $FirstItemOnlyInd;
    /**
     * The RemoveFromQueueInd
     * Meta information extracted from the WSDL
     * - documentation: If true, items are to be removed from the queue after display. If false, items are to remain on the queue after display. If this attribute is omitted, items on the queue are to be retained on the queue.
     * @var bool
     */
    public $RemoveFromQueueInd;
    /**
     * The FullDataInd
     * Meta information extracted from the WSDL
     * - documentation: Option to define if the full booking file data need to be returned. If true, all booking file info is returned. If false, only the condensed info is returned.
     * @var bool
     */
    public $FullDataInd;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - documentation: Bookings modified after this start date or date time should be returned. If used in conjunction with an end date, only bookings modified within that date range should be returned. | A construct to validate either a date or a dateTime
     * value.
     * - union: date | dateTime
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - documentation: Bookings modified before this end date or date time should be returned. If used in conjunction with a start date, only bookings modified within that date range should be returned. | A construct to validate either a date or a dateTime
     * value.
     * - union: date | dateTime
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for QueueInfo
     * @uses QueueInfo::setQueue()
     * @uses QueueInfo::setFirstItemOnlyInd()
     * @uses QueueInfo::setRemoveFromQueueInd()
     * @uses QueueInfo::setFullDataInd()
     * @uses QueueInfo::setStartDate()
     * @uses QueueInfo::setEndDate()
     * @param \StructType\Queue[] $queue
     * @param bool $firstItemOnlyInd
     * @param bool $removeFromQueueInd
     * @param bool $fullDataInd
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct(array $queue = array(), $firstItemOnlyInd = null, $removeFromQueueInd = null, $fullDataInd = null, $startDate = null, $endDate = null)
    {
        $this
            ->setQueue($queue)
            ->setFirstItemOnlyInd($firstItemOnlyInd)
            ->setRemoveFromQueueInd($removeFromQueueInd)
            ->setFullDataInd($fullDataInd)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get Queue value
     * @return \StructType\Queue[]|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * This method is responsible for validating the values passed to the setQueue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueueForArrayConstraintsFromSetQueue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queueInfoQueueItem) {
            // validation for constraint: itemType
            if (!$queueInfoQueueItem instanceof \StructType\Queue) {
                $invalidValues[] = is_object($queueInfoQueueItem) ? get_class($queueInfoQueueItem) : sprintf('%s(%s)', gettype($queueInfoQueueItem), var_export($queueInfoQueueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Queue property can only contain items of type \StructType\Queue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue[] $queue
     * @return \StructType\QueueInfo
     */
    public function setQueue(array $queue = array())
    {
        // validation for constraint: array
        if ('' !== ($queueArrayErrorMessage = self::validateQueueForArrayConstraintsFromSetQueue($queue))) {
            throw new \InvalidArgumentException($queueArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($queue) && count($queue) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($queue)), __LINE__);
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Add item to Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue $item
     * @return \StructType\QueueInfo
     */
    public function addToQueue(\StructType\Queue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Queue) {
            throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of type \StructType\Queue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Queue) && count($this->Queue) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Queue)), __LINE__);
        }
        $this->Queue[] = $item;
        return $this;
    }
    /**
     * Get FirstItemOnlyInd value
     * @return bool|null
     */
    public function getFirstItemOnlyInd()
    {
        return $this->FirstItemOnlyInd;
    }
    /**
     * Set FirstItemOnlyInd value
     * @param bool $firstItemOnlyInd
     * @return \StructType\QueueInfo
     */
    public function setFirstItemOnlyInd($firstItemOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstItemOnlyInd) && !is_bool($firstItemOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firstItemOnlyInd, true), gettype($firstItemOnlyInd)), __LINE__);
        }
        $this->FirstItemOnlyInd = $firstItemOnlyInd;
        return $this;
    }
    /**
     * Get RemoveFromQueueInd value
     * @return bool|null
     */
    public function getRemoveFromQueueInd()
    {
        return $this->RemoveFromQueueInd;
    }
    /**
     * Set RemoveFromQueueInd value
     * @param bool $removeFromQueueInd
     * @return \StructType\QueueInfo
     */
    public function setRemoveFromQueueInd($removeFromQueueInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeFromQueueInd) && !is_bool($removeFromQueueInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeFromQueueInd, true), gettype($removeFromQueueInd)), __LINE__);
        }
        $this->RemoveFromQueueInd = $removeFromQueueInd;
        return $this;
    }
    /**
     * Get FullDataInd value
     * @return bool|null
     */
    public function getFullDataInd()
    {
        return $this->FullDataInd;
    }
    /**
     * Set FullDataInd value
     * @param bool $fullDataInd
     * @return \StructType\QueueInfo
     */
    public function setFullDataInd($fullDataInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullDataInd) && !is_bool($fullDataInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullDataInd, true), gettype($fullDataInd)), __LINE__);
        }
        $this->FullDataInd = $fullDataInd;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * This method is responsible for validating the value passed to the setStartDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStartDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setStartDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartDateForUnionConstraintsFromSetStartDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\QueueInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($startDateUnionErrorMessage = self::validateStartDateForUnionConstraintsFromSetStartDate($startDate))) {
            throw new \InvalidArgumentException($startDateUnionErrorMessage, __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * This method is responsible for validating the value passed to the setEndDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEndDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setEndDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndDateForUnionConstraintsFromSetEndDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\QueueInfo
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($endDateUnionErrorMessage = self::validateEndDateForUnionConstraintsFromSetEndDate($endDate))) {
            throw new \InvalidArgumentException($endDateUnionErrorMessage, __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueueInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
