<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Queue StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies queue information for this booking. | Information to identify a queue. | Information to specify the queue on which the reservation should be placed. | Specifies queue information.
 * @subpackage Structs
 */
class Queue extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - documentation: Date/time when the time initiated queuing should take place.
     * - use: optional
     * @var string
     */
    public $DateTime;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Text describing why the queuing takes place.
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies airline/system on which the reservation is being queued.
     * - use: optional
     * @var string
     */
    public $CarrierCode;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * @var string
     */
    public $QueueNumber;
    /**
     * The QueueCategory
     * @var string
     */
    public $QueueCategory;
    /**
     * The SystemCode
     * @var string
     */
    public $SystemCode;
    /**
     * The QueueID
     * @var string
     */
    public $QueueID;
    /**
     * Constructor method for Queue
     * @uses Queue::setDateTime()
     * @uses Queue::setText()
     * @uses Queue::setCarrierCode()
     * @uses Queue::setOperation()
     * @uses Queue::setPseudoCityCode()
     * @uses Queue::setQueueNumber()
     * @uses Queue::setQueueCategory()
     * @uses Queue::setSystemCode()
     * @uses Queue::setQueueID()
     * @param string $dateTime
     * @param string $text
     * @param string $carrierCode
     * @param string $operation
     * @param string $pseudoCityCode
     * @param string $queueNumber
     * @param string $queueCategory
     * @param string $systemCode
     * @param string $queueID
     */
    public function __construct($dateTime = null, $text = null, $carrierCode = null, $operation = null, $pseudoCityCode = null, $queueNumber = null, $queueCategory = null, $systemCode = null, $queueID = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setText($text)
            ->setCarrierCode($carrierCode)
            ->setOperation($operation)
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueCategory($queueCategory)
            ->setSystemCode($systemCode)
            ->setQueueID($queueID);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Queue
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\Queue
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\Queue
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\Queue
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\Queue
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pseudoCityCode, true), gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return string|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \StructType\Queue
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueNumber, true), gettype($queueNumber)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueCategory value
     * @return string|null
     */
    public function getQueueCategory()
    {
        return $this->QueueCategory;
    }
    /**
     * Set QueueCategory value
     * @param string $queueCategory
     * @return \StructType\Queue
     */
    public function setQueueCategory($queueCategory = null)
    {
        // validation for constraint: string
        if (!is_null($queueCategory) && !is_string($queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueCategory, true), gettype($queueCategory)), __LINE__);
        }
        $this->QueueCategory = $queueCategory;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return string|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param string $systemCode
     * @return \StructType\Queue
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCode, true), gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Get QueueID value
     * @return string|null
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param string $queueID
     * @return \StructType\Queue
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: string
        if (!is_null($queueID) && !is_string($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueID, true), gettype($queueID)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Queue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
