<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchasedItem StructType
 * Meta information extracted from the WSDL
 * - documentation: An item previously purchased for this trip using airline or ATPCO encoding. This list is used to filter redundant offers.
 * @subpackage Structs
 */
class PurchasedItem extends AncillaryServiceDetailType
{
    /**
     * The AppliesTo
     * Meta information extracted from the WSDL
     * - documentation: References to traveler, O/D, O/D segment and O/D flight segment that indicate the applied pricing method.
     * - minOccurs: 0
     * @var mixed
     */
    public $AppliesTo;
    /**
     * The LandProductInfo
     * Meta information extracted from the WSDL
     * - documentation: Information about purchased land product(s), such as lounge passes.
     * - minOccurs: 0
     * @var mixed
     */
    public $LandProductInfo;
    /**
     * The InsuranceProduct
     * Meta information extracted from the WSDL
     * - documentation: Third-party trip insurance information.
     * - minOccurs: 0
     * @var mixed
     */
    public $InsuranceProduct;
    /**
     * Constructor method for PurchasedItem
     * @uses PurchasedItem::setAppliesTo()
     * @uses PurchasedItem::setLandProductInfo()
     * @uses PurchasedItem::setInsuranceProduct()
     * @param mixed $appliesTo
     * @param mixed $landProductInfo
     * @param mixed $insuranceProduct
     */
    public function __construct($appliesTo = null, $landProductInfo = null, $insuranceProduct = null)
    {
        $this
            ->setAppliesTo($appliesTo)
            ->setLandProductInfo($landProductInfo)
            ->setInsuranceProduct($insuranceProduct);
    }
    /**
     * Get AppliesTo value
     * @return mixed|null
     */
    public function getAppliesTo()
    {
        return $this->AppliesTo;
    }
    /**
     * Set AppliesTo value
     * @param mixed $appliesTo
     * @return \StructType\PurchasedItem
     */
    public function setAppliesTo($appliesTo = null)
    {
        $this->AppliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get LandProductInfo value
     * @return mixed|null
     */
    public function getLandProductInfo()
    {
        return $this->LandProductInfo;
    }
    /**
     * Set LandProductInfo value
     * @param mixed $landProductInfo
     * @return \StructType\PurchasedItem
     */
    public function setLandProductInfo($landProductInfo = null)
    {
        $this->LandProductInfo = $landProductInfo;
        return $this;
    }
    /**
     * Get InsuranceProduct value
     * @return mixed|null
     */
    public function getInsuranceProduct()
    {
        return $this->InsuranceProduct;
    }
    /**
     * Set InsuranceProduct value
     * @param mixed $insuranceProduct
     * @return \StructType\PurchasedItem
     */
    public function setInsuranceProduct($insuranceProduct = null)
    {
        $this->InsuranceProduct = $insuranceProduct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchasedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
