<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Promotions StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of packages and promotions.
 * @subpackage Structs
 */
class Promotions extends AbstractStructBase
{
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Promotion[]
     */
    public $Promotion;
    /**
     * Constructor method for Promotions
     * @uses Promotions::setPromotion()
     * @param \StructType\Promotion[] $promotion
     */
    public function __construct(array $promotion = array())
    {
        $this
            ->setPromotion($promotion);
    }
    /**
     * Get Promotion value
     * @return \StructType\Promotion[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $promotionsPromotionItem) {
            // validation for constraint: itemType
            if (!$promotionsPromotionItem instanceof \StructType\Promotion) {
                $invalidValues[] = is_object($promotionsPromotionItem) ? get_class($promotionsPromotionItem) : sprintf('%s(%s)', gettype($promotionsPromotionItem), var_export($promotionsPromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\Promotion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\Promotion[] $promotion
     * @return \StructType\Promotions
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\Promotion $item
     * @return \StructType\Promotions
     */
    public function addToPromotion(\StructType\Promotion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Promotion) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\Promotion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Promotions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
