<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductGroup StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline or ATPCO encoded product group code(s) that are associated with the service code. | Airline or ATPCO product group code(s) that are associated with the service code.
 * @subpackage Structs
 */
class ProductGroup extends AbstractStructBase
{
    /**
     * The SubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubGroup[]
     */
    public $SubGroup;
    /**
     * The CodeSource
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CodeSource;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: ATPCO calls a product group a "Service Code." | A unique code for a product group that may be airline defined or a RFIC (reason for issuance code.)
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the group code.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The BrandedFareName
     * Meta information extracted from the WSDL
     * - documentation: A pure fare that sits within a fare family. This is a fare associated with a brand (fare basis code) and at this level does not describe what is included.
     * - use: optional
     * @var string
     */
    public $BrandedFareName;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this product group that is referenced elsewhere in this schema.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ResultsAction
     * Meta information extracted from the WSDL
     * - documentation: An indicator if the product group is required and/or should be included or excluded from the offer results.
     * - use: optional
     * @var string
     */
    public $ResultsAction;
    /**
     * Constructor method for ProductGroup
     * @uses ProductGroup::setSubGroup()
     * @uses ProductGroup::setCodeSource()
     * @uses ProductGroup::setCode()
     * @uses ProductGroup::setDescription()
     * @uses ProductGroup::setBrandedFareName()
     * @uses ProductGroup::setRPH()
     * @uses ProductGroup::setResultsAction()
     * @param \StructType\SubGroup[] $subGroup
     * @param string $codeSource
     * @param string $code
     * @param string $description
     * @param string $brandedFareName
     * @param string $rPH
     * @param string $resultsAction
     */
    public function __construct(array $subGroup = array(), $codeSource = null, $code = null, $description = null, $brandedFareName = null, $rPH = null, $resultsAction = null)
    {
        $this
            ->setSubGroup($subGroup)
            ->setCodeSource($codeSource)
            ->setCode($code)
            ->setDescription($description)
            ->setBrandedFareName($brandedFareName)
            ->setRPH($rPH)
            ->setResultsAction($resultsAction);
    }
    /**
     * Get SubGroup value
     * @return \StructType\SubGroup[]|null
     */
    public function getSubGroup()
    {
        return $this->SubGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setSubGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubGroupForArrayConstraintsFromSetSubGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productGroupSubGroupItem) {
            // validation for constraint: itemType
            if (!$productGroupSubGroupItem instanceof \StructType\SubGroup) {
                $invalidValues[] = is_object($productGroupSubGroupItem) ? get_class($productGroupSubGroupItem) : sprintf('%s(%s)', gettype($productGroupSubGroupItem), var_export($productGroupSubGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubGroup property can only contain items of type \StructType\SubGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup[] $subGroup
     * @return \StructType\ProductGroup
     */
    public function setSubGroup(array $subGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($subGroupArrayErrorMessage = self::validateSubGroupForArrayConstraintsFromSetSubGroup($subGroup))) {
            throw new \InvalidArgumentException($subGroupArrayErrorMessage, __LINE__);
        }
        $this->SubGroup = $subGroup;
        return $this;
    }
    /**
     * Add item to SubGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroup $item
     * @return \StructType\ProductGroup
     */
    public function addToSubGroup(\StructType\SubGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubGroup) {
            throw new \InvalidArgumentException(sprintf('The SubGroup property can only contain items of type \StructType\SubGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubGroup[] = $item;
        return $this;
    }
    /**
     * Get CodeSource value
     * @return string|null
     */
    public function getCodeSource()
    {
        return $this->CodeSource;
    }
    /**
     * Set CodeSource value
     * @param string $codeSource
     * @return \StructType\ProductGroup
     */
    public function setCodeSource($codeSource = null)
    {
        // validation for constraint: string
        if (!is_null($codeSource) && !is_string($codeSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeSource, true), gettype($codeSource)), __LINE__);
        }
        $this->CodeSource = $codeSource;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ProductGroup
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ProductGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BrandedFareName value
     * @return string|null
     */
    public function getBrandedFareName()
    {
        return $this->BrandedFareName;
    }
    /**
     * Set BrandedFareName value
     * @param string $brandedFareName
     * @return \StructType\ProductGroup
     */
    public function setBrandedFareName($brandedFareName = null)
    {
        // validation for constraint: string
        if (!is_null($brandedFareName) && !is_string($brandedFareName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandedFareName, true), gettype($brandedFareName)), __LINE__);
        }
        $this->BrandedFareName = $brandedFareName;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ProductGroup
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ResultsAction value
     * @return string|null
     */
    public function getResultsAction()
    {
        return $this->ResultsAction;
    }
    /**
     * Set ResultsAction value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultsAction
     * @return \StructType\ProductGroup
     */
    public function setResultsAction($resultsAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($resultsAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($resultsAction) ? implode(', ', $resultsAction) : var_export($resultsAction, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->ResultsAction = $resultsAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
