<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivateFareType StructType
 * Meta information extracted from the WSDL
 * - documentation: Rules and other information associated with private fares.
 * @subpackage Structs
 */
class PrivateFareType extends AbstractStructBase
{
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: Note: This is a code that uniquely identifies a corporate account number. | Example: IBM123 | Corporate account ID.
     * - use: required
     * @var string
     */
    public $AccountCode;
    /**
     * The Airport
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Airport[]
     */
    public $Airport;
    /**
     * The FareDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetails[]
     */
    public $FareDetails;
    /**
     * The FilingAirline
     * Meta information extracted from the WSDL
     * - documentation: Filing airline.
     * - minOccurs: 0
     * @var mixed
     */
    public $FilingAirline;
    /**
     * The MarketingAirline
     * Meta information extracted from the WSDL
     * - documentation: Marketing airline.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MarketingAirline;
    /**
     * The RuleInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RuleInfo
     */
    public $RuleInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The PrivateFareCode
     * Meta information extracted from the WSDL
     * - documentation: Example: SKY123 | Private fare code.
     * - use: optional
     * @var string
     */
    public $PrivateFareCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: OpenTravel Best Practice: All currency amounts should have the currency code type and decimal places specified. | OpenTravel Best Practice: Unless otherwise noted, all currency designations are three alpha characters and follow ISO
     * 4217 prescribed format. | Example: USD | Fare rule currency.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The NbrOfCities
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the number of cities applicable to this fare. | Example: 2 | City quantity.
     * - use: optional
     * @var int
     */
    public $NbrOfCities;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Definition: The code used in reservations transactions to identify a compartment on an aircraft and/or a special inventory control. It is the booking class usually determined by the fare basis. The RBDs are typically represented by
     * alphabetic characters. | Note: This identifies the class of service for the specified fare basis code. | Example: F | Reservation booking designator (RBD).
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The RoutingNumber
     * Meta information extracted from the WSDL
     * - documentation: Example: 0209 | Fare routing number.
     * - use: optional
     * @var int
     */
    public $RoutingNumber;
    /**
     * The TariffRuleNmbr
     * Meta information extracted from the WSDL
     * - documentation: Example: F2H | Tariff rule number.
     * - use: optional
     * @var string
     */
    public $TariffRuleNmbr;
    /**
     * The TarriffRuleDes
     * Meta information extracted from the WSDL
     * - documentation: Example: From/To Within USA | Tarriff rule description.
     * - use: optional
     * @var string
     */
    public $TarriffRuleDes;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the discount code applicable to the fare that is associated with this fare basis code. | Example: SWP30 | Ticket designator code.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The TicketDesignatorExtension
     * Meta information extracted from the WSDL
     * - documentation: Note: This is an extension that a carrier may apply to a ticket designator. | Example: HK4 | Ticket designator code extension.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorExtension;
    /**
     * The FlightRefRPH
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the flight to which this ticket designator applies. This ID was set elsewhere in the message. | Example: 1 | Flight reference ID.
     * - use: optional
     * @var string
     */
    public $FlightRefRPH;
    /**
     * Constructor method for PrivateFareType
     * @uses PrivateFareType::setAccountCode()
     * @uses PrivateFareType::setAirport()
     * @uses PrivateFareType::setFareDetails()
     * @uses PrivateFareType::setFilingAirline()
     * @uses PrivateFareType::setMarketingAirline()
     * @uses PrivateFareType::setRuleInfo()
     * @uses PrivateFareType::setTPA_Extensions()
     * @uses PrivateFareType::setPrivateFareCode()
     * @uses PrivateFareType::setCurrencyCode()
     * @uses PrivateFareType::setNbrOfCities()
     * @uses PrivateFareType::setResBookDesigCode()
     * @uses PrivateFareType::setRoutingNumber()
     * @uses PrivateFareType::setTariffRuleNmbr()
     * @uses PrivateFareType::setTarriffRuleDes()
     * @uses PrivateFareType::setTicketDesignatorCode()
     * @uses PrivateFareType::setTicketDesignatorExtension()
     * @uses PrivateFareType::setFlightRefRPH()
     * @param string $accountCode
     * @param \StructType\Airport[] $airport
     * @param \StructType\FareDetails[] $fareDetails
     * @param mixed $filingAirline
     * @param mixed[] $marketingAirline
     * @param \StructType\RuleInfo $ruleInfo
     * @param mixed $tPA_Extensions
     * @param string $privateFareCode
     * @param string $currencyCode
     * @param int $nbrOfCities
     * @param string $resBookDesigCode
     * @param int $routingNumber
     * @param string $tariffRuleNmbr
     * @param string $tarriffRuleDes
     * @param string $ticketDesignatorCode
     * @param string $ticketDesignatorExtension
     * @param string $flightRefRPH
     */
    public function __construct($accountCode = null, array $airport = array(), array $fareDetails = array(), $filingAirline = null, array $marketingAirline = array(), \StructType\RuleInfo $ruleInfo = null, $tPA_Extensions = null, $privateFareCode = null, $currencyCode = null, $nbrOfCities = null, $resBookDesigCode = null, $routingNumber = null, $tariffRuleNmbr = null, $tarriffRuleDes = null, $ticketDesignatorCode = null, $ticketDesignatorExtension = null, $flightRefRPH = null)
    {
        $this
            ->setAccountCode($accountCode)
            ->setAirport($airport)
            ->setFareDetails($fareDetails)
            ->setFilingAirline($filingAirline)
            ->setMarketingAirline($marketingAirline)
            ->setRuleInfo($ruleInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPrivateFareCode($privateFareCode)
            ->setCurrencyCode($currencyCode)
            ->setNbrOfCities($nbrOfCities)
            ->setResBookDesigCode($resBookDesigCode)
            ->setRoutingNumber($routingNumber)
            ->setTariffRuleNmbr($tariffRuleNmbr)
            ->setTarriffRuleDes($tarriffRuleDes)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setTicketDesignatorExtension($ticketDesignatorExtension)
            ->setFlightRefRPH($flightRefRPH);
    }
    /**
     * Get AccountCode value
     * @return string
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\PrivateFareType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get Airport value
     * @return \StructType\Airport[]|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * This method is responsible for validating the values passed to the setAirport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportForArrayConstraintsFromSetAirport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privateFareTypeAirportItem) {
            // validation for constraint: itemType
            if (!$privateFareTypeAirportItem instanceof \StructType\Airport) {
                $invalidValues[] = is_object($privateFareTypeAirportItem) ? get_class($privateFareTypeAirportItem) : sprintf('%s(%s)', gettype($privateFareTypeAirportItem), var_export($privateFareTypeAirportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airport property can only contain items of type \StructType\Airport, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airport value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport[] $airport
     * @return \StructType\PrivateFareType
     */
    public function setAirport(array $airport = array())
    {
        // validation for constraint: array
        if ('' !== ($airportArrayErrorMessage = self::validateAirportForArrayConstraintsFromSetAirport($airport))) {
            throw new \InvalidArgumentException($airportArrayErrorMessage, __LINE__);
        }
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Add item to Airport value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport $item
     * @return \StructType\PrivateFareType
     */
    public function addToAirport(\StructType\Airport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Airport) {
            throw new \InvalidArgumentException(sprintf('The Airport property can only contain items of type \StructType\Airport, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airport[] = $item;
        return $this;
    }
    /**
     * Get FareDetails value
     * @return \StructType\FareDetails[]|null
     */
    public function getFareDetails()
    {
        return $this->FareDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailsForArrayConstraintsFromSetFareDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privateFareTypeFareDetailsItem) {
            // validation for constraint: itemType
            if (!$privateFareTypeFareDetailsItem instanceof \StructType\FareDetails) {
                $invalidValues[] = is_object($privateFareTypeFareDetailsItem) ? get_class($privateFareTypeFareDetailsItem) : sprintf('%s(%s)', gettype($privateFareTypeFareDetailsItem), var_export($privateFareTypeFareDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetails property can only contain items of type \StructType\FareDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetails[] $fareDetails
     * @return \StructType\PrivateFareType
     */
    public function setFareDetails(array $fareDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailsArrayErrorMessage = self::validateFareDetailsForArrayConstraintsFromSetFareDetails($fareDetails))) {
            throw new \InvalidArgumentException($fareDetailsArrayErrorMessage, __LINE__);
        }
        $this->FareDetails = $fareDetails;
        return $this;
    }
    /**
     * Add item to FareDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetails $item
     * @return \StructType\PrivateFareType
     */
    public function addToFareDetails(\StructType\FareDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetails) {
            throw new \InvalidArgumentException(sprintf('The FareDetails property can only contain items of type \StructType\FareDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetails[] = $item;
        return $this;
    }
    /**
     * Get FilingAirline value
     * @return mixed|null
     */
    public function getFilingAirline()
    {
        return $this->FilingAirline;
    }
    /**
     * Set FilingAirline value
     * @param mixed $filingAirline
     * @return \StructType\PrivateFareType
     */
    public function setFilingAirline($filingAirline = null)
    {
        $this->FilingAirline = $filingAirline;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return mixed[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingAirline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingAirline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingAirlineForArrayConstraintsFromSetMarketingAirline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privateFareTypeMarketingAirlineItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($privateFareTypeMarketingAirlineItem) ? get_class($privateFareTypeMarketingAirlineItem) : sprintf('%s(%s)', gettype($privateFareTypeMarketingAirlineItem), var_export($privateFareTypeMarketingAirlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingAirline property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed[] $marketingAirline
     * @return \StructType\PrivateFareType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingAirlineArrayErrorMessage = self::validateMarketingAirlineForArrayConstraintsFromSetMarketingAirline($marketingAirline))) {
            throw new \InvalidArgumentException($marketingAirlineArrayErrorMessage, __LINE__);
        }
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PrivateFareType
     */
    public function addToMarketingAirline($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \StructType\RuleInfo|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \StructType\RuleInfo $ruleInfo
     * @return \StructType\PrivateFareType
     */
    public function setRuleInfo(\StructType\RuleInfo $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\PrivateFareType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PrivateFareCode value
     * @return string|null
     */
    public function getPrivateFareCode()
    {
        return $this->PrivateFareCode;
    }
    /**
     * Set PrivateFareCode value
     * @param string $privateFareCode
     * @return \StructType\PrivateFareType
     */
    public function setPrivateFareCode($privateFareCode = null)
    {
        // validation for constraint: string
        if (!is_null($privateFareCode) && !is_string($privateFareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privateFareCode, true), gettype($privateFareCode)), __LINE__);
        }
        $this->PrivateFareCode = $privateFareCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\PrivateFareType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get NbrOfCities value
     * @return int|null
     */
    public function getNbrOfCities()
    {
        return $this->NbrOfCities;
    }
    /**
     * Set NbrOfCities value
     * @param int $nbrOfCities
     * @return \StructType\PrivateFareType
     */
    public function setNbrOfCities($nbrOfCities = null)
    {
        // validation for constraint: int
        if (!is_null($nbrOfCities) && !(is_int($nbrOfCities) || ctype_digit($nbrOfCities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbrOfCities, true), gettype($nbrOfCities)), __LINE__);
        }
        $this->NbrOfCities = $nbrOfCities;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\PrivateFareType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return int|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param int $routingNumber
     * @return \StructType\PrivateFareType
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: int
        if (!is_null($routingNumber) && !(is_int($routingNumber) || ctype_digit($routingNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routingNumber, true), gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get TariffRuleNmbr value
     * @return string|null
     */
    public function getTariffRuleNmbr()
    {
        return $this->TariffRuleNmbr;
    }
    /**
     * Set TariffRuleNmbr value
     * @param string $tariffRuleNmbr
     * @return \StructType\PrivateFareType
     */
    public function setTariffRuleNmbr($tariffRuleNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($tariffRuleNmbr) && !is_string($tariffRuleNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffRuleNmbr, true), gettype($tariffRuleNmbr)), __LINE__);
        }
        $this->TariffRuleNmbr = $tariffRuleNmbr;
        return $this;
    }
    /**
     * Get TarriffRuleDes value
     * @return string|null
     */
    public function getTarriffRuleDes()
    {
        return $this->TarriffRuleDes;
    }
    /**
     * Set TarriffRuleDes value
     * @param string $tarriffRuleDes
     * @return \StructType\PrivateFareType
     */
    public function setTarriffRuleDes($tarriffRuleDes = null)
    {
        // validation for constraint: string
        if (!is_null($tarriffRuleDes) && !is_string($tarriffRuleDes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarriffRuleDes, true), gettype($tarriffRuleDes)), __LINE__);
        }
        $this->TarriffRuleDes = $tarriffRuleDes;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\PrivateFareType
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get TicketDesignatorExtension value
     * @return string|null
     */
    public function getTicketDesignatorExtension()
    {
        return $this->TicketDesignatorExtension;
    }
    /**
     * Set TicketDesignatorExtension value
     * @param string $ticketDesignatorExtension
     * @return \StructType\PrivateFareType
     */
    public function setTicketDesignatorExtension($ticketDesignatorExtension = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorExtension) && !is_string($ticketDesignatorExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorExtension, true), gettype($ticketDesignatorExtension)), __LINE__);
        }
        $this->TicketDesignatorExtension = $ticketDesignatorExtension;
        return $this;
    }
    /**
     * Get FlightRefRPH value
     * @return string|null
     */
    public function getFlightRefRPH()
    {
        return $this->FlightRefRPH;
    }
    /**
     * Set FlightRefRPH value
     * @param string $flightRefRPH
     * @return \StructType\PrivateFareType
     */
    public function setFlightRefRPH($flightRefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($flightRefRPH) && !is_string($flightRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightRefRPH, true), gettype($flightRefRPH)), __LINE__);
        }
        $this->FlightRefRPH = $flightRefRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrivateFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
