<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedEquips StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of special equipment that is part of this reservation, along with the charges associated with this equipment. | A collection of special equipment that is part of this quote, along with the charges associated with this
 * equipment.
 * @subpackage Structs
 */
class PricedEquips extends AbstractStructBase
{
    /**
     * The PricedEquip
     * Meta information extracted from the WSDL
     * - documentation: A specific piece of special equipment, along with the quantity, restrictions and charge.
     * - maxOccurs: 25
     * @var mixed[]
     */
    public $PricedEquip;
    /**
     * Constructor method for PricedEquips
     * @uses PricedEquips::setPricedEquip()
     * @param mixed[] $pricedEquip
     */
    public function __construct(array $pricedEquip = array())
    {
        $this
            ->setPricedEquip($pricedEquip);
    }
    /**
     * Get PricedEquip value
     * @return mixed[]|null
     */
    public function getPricedEquip()
    {
        return $this->PricedEquip;
    }
    /**
     * This method is responsible for validating the values passed to the setPricedEquip method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricedEquip method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricedEquipForArrayConstraintsFromSetPricedEquip(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricedEquipsPricedEquipItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricedEquipsPricedEquipItem) ? get_class($pricedEquipsPricedEquipItem) : sprintf('%s(%s)', gettype($pricedEquipsPricedEquipItem), var_export($pricedEquipsPricedEquipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricedEquip property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricedEquip value
     * @throws \InvalidArgumentException
     * @param mixed[] $pricedEquip
     * @return \StructType\PricedEquips
     */
    public function setPricedEquip(array $pricedEquip = array())
    {
        // validation for constraint: array
        if ('' !== ($pricedEquipArrayErrorMessage = self::validatePricedEquipForArrayConstraintsFromSetPricedEquip($pricedEquip))) {
            throw new \InvalidArgumentException($pricedEquipArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($pricedEquip) && count($pricedEquip) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 25', count($pricedEquip)), __LINE__);
        }
        $this->PricedEquip = $pricedEquip;
        return $this;
    }
    /**
     * Add item to PricedEquip value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PricedEquips
     */
    public function addToPricedEquip($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PricedEquip property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($this->PricedEquip) && count($this->PricedEquip) >= 25) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 25', count($this->PricedEquip)), __LINE__);
        }
        $this->PricedEquip[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedEquips
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
