<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedCoverages StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of vehicle coverages associated with this reservation. | A collection of coverages, along with associated price and details.
 * @subpackage Structs
 */
class PricedCoverages extends AbstractStructBase
{
    /**
     * The PricedCoverage
     * Meta information extracted from the WSDL
     * - documentation: One specific coverage associated with this reservation. | One specific vehicle coverage along with the corresponding charge.
     * - maxOccurs: 15
     * @var mixed[]
     */
    public $PricedCoverage;
    /**
     * Constructor method for PricedCoverages
     * @uses PricedCoverages::setPricedCoverage()
     * @param mixed[] $pricedCoverage
     */
    public function __construct(array $pricedCoverage = array())
    {
        $this
            ->setPricedCoverage($pricedCoverage);
    }
    /**
     * Get PricedCoverage value
     * @return mixed[]|null
     */
    public function getPricedCoverage()
    {
        return $this->PricedCoverage;
    }
    /**
     * This method is responsible for validating the values passed to the setPricedCoverage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricedCoverage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricedCoverageForArrayConstraintsFromSetPricedCoverage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricedCoveragesPricedCoverageItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pricedCoveragesPricedCoverageItem) ? get_class($pricedCoveragesPricedCoverageItem) : sprintf('%s(%s)', gettype($pricedCoveragesPricedCoverageItem), var_export($pricedCoveragesPricedCoverageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricedCoverage property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricedCoverage value
     * @throws \InvalidArgumentException
     * @param mixed[] $pricedCoverage
     * @return \StructType\PricedCoverages
     */
    public function setPricedCoverage(array $pricedCoverage = array())
    {
        // validation for constraint: array
        if ('' !== ($pricedCoverageArrayErrorMessage = self::validatePricedCoverageForArrayConstraintsFromSetPricedCoverage($pricedCoverage))) {
            throw new \InvalidArgumentException($pricedCoverageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($pricedCoverage) && count($pricedCoverage) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($pricedCoverage)), __LINE__);
        }
        $this->PricedCoverage = $pricedCoverage;
        return $this;
    }
    /**
     * Add item to PricedCoverage value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PricedCoverages
     */
    public function addToPricedCoverage($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PricedCoverage property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->PricedCoverage) && count($this->PricedCoverage) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->PricedCoverage)), __LINE__);
        }
        $this->PricedCoverage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PricedCoverages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
