<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceableUnit StructType
 * Meta information extracted from the WSDL
 * - documentation: Priceable unit number.
 * @subpackage Structs
 */
class PriceableUnit extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: A sequential number representing the priceable unit in which the fare component resides.
     * - use: required
     * @var string
     */
    public $Number;
    /**
     * The FareComponentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FareComponentDetail[]
     */
    public $FareComponentDetail;
    /**
     * Constructor method for PriceableUnit
     * @uses PriceableUnit::setNumber()
     * @uses PriceableUnit::setFareComponentDetail()
     * @param string $number
     * @param \StructType\FareComponentDetail[] $fareComponentDetail
     */
    public function __construct($number = null, array $fareComponentDetail = array())
    {
        $this
            ->setNumber($number)
            ->setFareComponentDetail($fareComponentDetail);
    }
    /**
     * Get Number value
     * @return string
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\PriceableUnit
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get FareComponentDetail value
     * @return \StructType\FareComponentDetail[]|null
     */
    public function getFareComponentDetail()
    {
        return $this->FareComponentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareComponentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareComponentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareComponentDetailForArrayConstraintsFromSetFareComponentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceableUnitFareComponentDetailItem) {
            // validation for constraint: itemType
            if (!$priceableUnitFareComponentDetailItem instanceof \StructType\FareComponentDetail) {
                $invalidValues[] = is_object($priceableUnitFareComponentDetailItem) ? get_class($priceableUnitFareComponentDetailItem) : sprintf('%s(%s)', gettype($priceableUnitFareComponentDetailItem), var_export($priceableUnitFareComponentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareComponentDetail property can only contain items of type \StructType\FareComponentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareComponentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentDetail[] $fareComponentDetail
     * @return \StructType\PriceableUnit
     */
    public function setFareComponentDetail(array $fareComponentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareComponentDetailArrayErrorMessage = self::validateFareComponentDetailForArrayConstraintsFromSetFareComponentDetail($fareComponentDetail))) {
            throw new \InvalidArgumentException($fareComponentDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($fareComponentDetail) && count($fareComponentDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($fareComponentDetail)), __LINE__);
        }
        $this->FareComponentDetail = $fareComponentDetail;
        return $this;
    }
    /**
     * Add item to FareComponentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentDetail $item
     * @return \StructType\PriceableUnit
     */
    public function addToFareComponentDetail(\StructType\FareComponentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareComponentDetail) {
            throw new \InvalidArgumentException(sprintf('The FareComponentDetail property can only contain items of type \StructType\FareComponentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FareComponentDetail) && count($this->FareComponentDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FareComponentDetail)), __LINE__);
        }
        $this->FareComponentDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceableUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
