<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies pricing source, if negotiated fares are requested and if it is a reprice request.
 * @subpackage Structs
 */
class PriceRequestInformation extends PriceRequestInformationType
{
    /**
     * The FareRestrictionPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FareRestrictionPref[]
     */
    public $FareRestrictionPref;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Used to specify tax information which may be used to override the taxes in the pricing system.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Tax;
    /**
     * The DiscountPricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountPricing
     */
    public $DiscountPricing;
    /**
     * The SegmentOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \StructType\SegmentOverride[]
     */
    public $SegmentOverride;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Account[]
     */
    public $Account;
    /**
     * The LocationRequirement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationRequirement
     */
    public $LocationRequirement;
    /**
     * Constructor method for PriceRequestInformation
     * @uses PriceRequestInformation::setFareRestrictionPref()
     * @uses PriceRequestInformation::setTax()
     * @uses PriceRequestInformation::setDiscountPricing()
     * @uses PriceRequestInformation::setSegmentOverride()
     * @uses PriceRequestInformation::setAccount()
     * @uses PriceRequestInformation::setLocationRequirement()
     * @param \StructType\FareRestrictionPref[] $fareRestrictionPref
     * @param mixed[] $tax
     * @param \StructType\DiscountPricing $discountPricing
     * @param \StructType\SegmentOverride[] $segmentOverride
     * @param \StructType\Account[] $account
     * @param \StructType\LocationRequirement $locationRequirement
     */
    public function __construct(array $fareRestrictionPref = array(), array $tax = array(), \StructType\DiscountPricing $discountPricing = null, array $segmentOverride = array(), array $account = array(), \StructType\LocationRequirement $locationRequirement = null)
    {
        $this
            ->setFareRestrictionPref($fareRestrictionPref)
            ->setTax($tax)
            ->setDiscountPricing($discountPricing)
            ->setSegmentOverride($segmentOverride)
            ->setAccount($account)
            ->setLocationRequirement($locationRequirement);
    }
    /**
     * Get FareRestrictionPref value
     * @return \StructType\FareRestrictionPref[]|null
     */
    public function getFareRestrictionPref()
    {
        return $this->FareRestrictionPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRestrictionPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRestrictionPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRestrictionPrefForArrayConstraintsFromSetFareRestrictionPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationFareRestrictionPrefItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationFareRestrictionPrefItem instanceof \StructType\FareRestrictionPref) {
                $invalidValues[] = is_object($priceRequestInformationFareRestrictionPrefItem) ? get_class($priceRequestInformationFareRestrictionPrefItem) : sprintf('%s(%s)', gettype($priceRequestInformationFareRestrictionPrefItem), var_export($priceRequestInformationFareRestrictionPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRestrictionPref property can only contain items of type \StructType\FareRestrictionPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRestrictionPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictionPref[] $fareRestrictionPref
     * @return \StructType\PriceRequestInformation
     */
    public function setFareRestrictionPref(array $fareRestrictionPref = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRestrictionPrefArrayErrorMessage = self::validateFareRestrictionPrefForArrayConstraintsFromSetFareRestrictionPref($fareRestrictionPref))) {
            throw new \InvalidArgumentException($fareRestrictionPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($fareRestrictionPref) && count($fareRestrictionPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($fareRestrictionPref)), __LINE__);
        }
        $this->FareRestrictionPref = $fareRestrictionPref;
        return $this;
    }
    /**
     * Add item to FareRestrictionPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictionPref $item
     * @return \StructType\PriceRequestInformation
     */
    public function addToFareRestrictionPref(\StructType\FareRestrictionPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRestrictionPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictionPref property can only contain items of type \StructType\FareRestrictionPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->FareRestrictionPref) && count($this->FareRestrictionPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->FareRestrictionPref)), __LINE__);
        }
        $this->FareRestrictionPref[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return mixed[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationTaxItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($priceRequestInformationTaxItem) ? get_class($priceRequestInformationTaxItem) : sprintf('%s(%s)', gettype($priceRequestInformationTaxItem), var_export($priceRequestInformationTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param mixed[] $tax
     * @return \StructType\PriceRequestInformation
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($tax) && count($tax) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($tax)), __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PriceRequestInformation
     */
    public function addToTax($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Tax) && count($this->Tax) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Tax)), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get DiscountPricing value
     * @return \StructType\DiscountPricing|null
     */
    public function getDiscountPricing()
    {
        return $this->DiscountPricing;
    }
    /**
     * Set DiscountPricing value
     * @param \StructType\DiscountPricing $discountPricing
     * @return \StructType\PriceRequestInformation
     */
    public function setDiscountPricing(\StructType\DiscountPricing $discountPricing = null)
    {
        $this->DiscountPricing = $discountPricing;
        return $this;
    }
    /**
     * Get SegmentOverride value
     * @return \StructType\SegmentOverride[]|null
     */
    public function getSegmentOverride()
    {
        return $this->SegmentOverride;
    }
    /**
     * This method is responsible for validating the values passed to the setSegmentOverride method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentOverride method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentOverrideForArrayConstraintsFromSetSegmentOverride(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationSegmentOverrideItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationSegmentOverrideItem instanceof \StructType\SegmentOverride) {
                $invalidValues[] = is_object($priceRequestInformationSegmentOverrideItem) ? get_class($priceRequestInformationSegmentOverrideItem) : sprintf('%s(%s)', gettype($priceRequestInformationSegmentOverrideItem), var_export($priceRequestInformationSegmentOverrideItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SegmentOverride property can only contain items of type \StructType\SegmentOverride, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SegmentOverride value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentOverride[] $segmentOverride
     * @return \StructType\PriceRequestInformation
     */
    public function setSegmentOverride(array $segmentOverride = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentOverrideArrayErrorMessage = self::validateSegmentOverrideForArrayConstraintsFromSetSegmentOverride($segmentOverride))) {
            throw new \InvalidArgumentException($segmentOverrideArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($segmentOverride) && count($segmentOverride) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($segmentOverride)), __LINE__);
        }
        $this->SegmentOverride = $segmentOverride;
        return $this;
    }
    /**
     * Add item to SegmentOverride value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentOverride $item
     * @return \StructType\PriceRequestInformation
     */
    public function addToSegmentOverride(\StructType\SegmentOverride $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SegmentOverride) {
            throw new \InvalidArgumentException(sprintf('The SegmentOverride property can only contain items of type \StructType\SegmentOverride, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->SegmentOverride) && count($this->SegmentOverride) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->SegmentOverride)), __LINE__);
        }
        $this->SegmentOverride[] = $item;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Account[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceRequestInformationAccountItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationAccountItem instanceof \StructType\Account) {
                $invalidValues[] = is_object($priceRequestInformationAccountItem) ? get_class($priceRequestInformationAccountItem) : sprintf('%s(%s)', gettype($priceRequestInformationAccountItem), var_export($priceRequestInformationAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Account property can only contain items of type \StructType\Account, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account[] $account
     * @return \StructType\PriceRequestInformation
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($account) && count($account) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account $item
     * @return \StructType\PriceRequestInformation
     */
    public function addToAccount(\StructType\Account $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Account) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of type \StructType\Account, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Account) && count($this->Account) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Account)), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
    /**
     * Get LocationRequirement value
     * @return \StructType\LocationRequirement|null
     */
    public function getLocationRequirement()
    {
        return $this->LocationRequirement;
    }
    /**
     * Set LocationRequirement value
     * @param \StructType\LocationRequirement $locationRequirement
     * @return \StructType\PriceRequestInformation
     */
    public function setLocationRequirement(\StructType\LocationRequirement $locationRequirement = null)
    {
        $this->LocationRequirement = $locationRequirement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceRequestInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
