<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresentInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: The present to and at information.
 * @subpackage Structs
 */
class PresentInfo extends AbstractStructBase
{
    /**
     * The To
     * Meta information extracted from the WSDL
     * - documentation: The name of the service provider. | Name of service provider.
     * - use: optional
     * @var string
     */
    public $To;
    /**
     * The At
     * Meta information extracted from the WSDL
     * - documentation: The location of the service provider.
     * - use: optional
     * @var string
     */
    public $At;
    /**
     * Constructor method for PresentInfo
     * @uses PresentInfo::setTo()
     * @uses PresentInfo::setAt()
     * @param string $to
     * @param string $at
     */
    public function __construct($to = null, $at = null)
    {
        $this
            ->setTo($to)
            ->setAt($at);
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\PresentInfo
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get At value
     * @return string|null
     */
    public function getAt()
    {
        return $this->At;
    }
    /**
     * Set At value
     * @param string $at
     * @return \StructType\PresentInfo
     */
    public function setAt($at = null)
    {
        // validation for constraint: string
        if (!is_null($at) && !is_string($at)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($at, true), gettype($at)), __LINE__);
        }
        $this->At = $at;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PresentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
