<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoliciesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the policies of the hotel, such as the type of payments, or whether children or pets are accepted.
 * @subpackage Structs
 */
class PoliciesType extends AbstractStructBase
{
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Policy[]
     */
    public $Policy;
    /**
     * Constructor method for PoliciesType
     * @uses PoliciesType::setPolicy()
     * @param \StructType\Policy[] $policy
     */
    public function __construct(array $policy = array())
    {
        $this
            ->setPolicy($policy);
    }
    /**
     * Get Policy value
     * @return \StructType\Policy[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $policiesTypePolicyItem) {
            // validation for constraint: itemType
            if (!$policiesTypePolicyItem instanceof \StructType\Policy) {
                $invalidValues[] = is_object($policiesTypePolicyItem) ? get_class($policiesTypePolicyItem) : sprintf('%s(%s)', gettype($policiesTypePolicyItem), var_export($policiesTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\Policy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy[] $policy
     * @return \StructType\PoliciesType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\Policy $item
     * @return \StructType\PoliciesType
     */
    public function addToPolicy(\StructType\Policy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Policy) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\Policy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PoliciesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
