<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgRoomInventoryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes a type of room/cabin/apartment etc.
 * @subpackage Structs
 */
class PkgRoomInventoryType extends RoomStayCandidateType
{
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SupplementCharges;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A full description of the room/apartment etc.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The MaxAdults
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of adults allowed in a unit of accommodation.
     * - use: optional
     * @var int
     */
    public $MaxAdults;
    /**
     * The CotQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of cots/cribs available in a room/apartment etc.
     * - use: optional
     * @var int
     */
    public $CotQuantity;
    /**
     * The FreeChildFlag
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a free child is permitted in a room/apartment etc.
     * - use: optional
     * @var bool
     */
    public $FreeChildFlag;
    /**
     * Constructor method for PkgRoomInventoryType
     * @uses PkgRoomInventoryType::setSupplementCharges()
     * @uses PkgRoomInventoryType::setDescription()
     * @uses PkgRoomInventoryType::setMaxAdults()
     * @uses PkgRoomInventoryType::setCotQuantity()
     * @uses PkgRoomInventoryType::setFreeChildFlag()
     * @param mixed[] $supplementCharges
     * @param string $description
     * @param int $maxAdults
     * @param int $cotQuantity
     * @param bool $freeChildFlag
     */
    public function __construct(array $supplementCharges = array(), $description = null, $maxAdults = null, $cotQuantity = null, $freeChildFlag = null)
    {
        $this
            ->setSupplementCharges($supplementCharges)
            ->setDescription($description)
            ->setMaxAdults($maxAdults)
            ->setCotQuantity($cotQuantity)
            ->setFreeChildFlag($freeChildFlag);
    }
    /**
     * Get SupplementCharges value
     * @return mixed[]|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplementCharges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplementCharges method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplementChargesForArrayConstraintsFromSetSupplementCharges(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pkgRoomInventoryTypeSupplementChargesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pkgRoomInventoryTypeSupplementChargesItem) ? get_class($pkgRoomInventoryTypeSupplementChargesItem) : sprintf('%s(%s)', gettype($pkgRoomInventoryTypeSupplementChargesItem), var_export($pkgRoomInventoryTypeSupplementChargesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplementCharges property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplementCharges value
     * @throws \InvalidArgumentException
     * @param mixed[] $supplementCharges
     * @return \StructType\PkgRoomInventoryType
     */
    public function setSupplementCharges(array $supplementCharges = array())
    {
        // validation for constraint: array
        if ('' !== ($supplementChargesArrayErrorMessage = self::validateSupplementChargesForArrayConstraintsFromSetSupplementCharges($supplementCharges))) {
            throw new \InvalidArgumentException($supplementChargesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($supplementCharges) && count($supplementCharges) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($supplementCharges)), __LINE__);
        }
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Add item to SupplementCharges value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PkgRoomInventoryType
     */
    public function addToSupplementCharges($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SupplementCharges property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->SupplementCharges) && count($this->SupplementCharges) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->SupplementCharges)), __LINE__);
        }
        $this->SupplementCharges[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PkgRoomInventoryType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get MaxAdults value
     * @return int|null
     */
    public function getMaxAdults()
    {
        return $this->MaxAdults;
    }
    /**
     * Set MaxAdults value
     * @param int $maxAdults
     * @return \StructType\PkgRoomInventoryType
     */
    public function setMaxAdults($maxAdults = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdults) && !(is_int($maxAdults) || ctype_digit($maxAdults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdults, true), gettype($maxAdults)), __LINE__);
        }
        $this->MaxAdults = $maxAdults;
        return $this;
    }
    /**
     * Get CotQuantity value
     * @return int|null
     */
    public function getCotQuantity()
    {
        return $this->CotQuantity;
    }
    /**
     * Set CotQuantity value
     * @param int $cotQuantity
     * @return \StructType\PkgRoomInventoryType
     */
    public function setCotQuantity($cotQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($cotQuantity) && !(is_int($cotQuantity) || ctype_digit($cotQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cotQuantity, true), gettype($cotQuantity)), __LINE__);
        }
        $this->CotQuantity = $cotQuantity;
        return $this;
    }
    /**
     * Get FreeChildFlag value
     * @return bool|null
     */
    public function getFreeChildFlag()
    {
        return $this->FreeChildFlag;
    }
    /**
     * Set FreeChildFlag value
     * @param bool $freeChildFlag
     * @return \StructType\PkgRoomInventoryType
     */
    public function setFreeChildFlag($freeChildFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($freeChildFlag) && !is_bool($freeChildFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($freeChildFlag, true), gettype($freeChildFlag)), __LINE__);
        }
        $this->FreeChildFlag = $freeChildFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgRoomInventoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
