<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgPassengerListItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of a passenger or of a quantity of generic passengers e.g. 2 children aged 5.
 * @subpackage Structs
 */
class PkgPassengerListItem extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the passenger or traveler.
     * - minOccurs: 0
     * @var mixed
     */
    public $Name;
    /**
     * The SpecialNeed
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\SpecialNeed[]
     */
    public $SpecialNeed;
    /**
     * The PassportInformation
     * Meta information extracted from the WSDL
     * - documentation: Details of the passenger's passport.
     * - minOccurs: 0
     * @var mixed
     */
    public $PassportInformation;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The InsuranceRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to associate this passenger with their insurance cover provided by the supplier.
     * - use: optional
     * @var string
     */
    public $InsuranceRPH;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the nationality of a person, if known. Uses ISO 3166 Country Codes.
     * - use: optional
     * @var string
     */
    public $Nationality;
    /**
     * The LeadCustomerInd
     * Meta information extracted from the WSDL
     * - documentation: When 'true', indicates that this is the 'lead' passenger (i.e., the primary contact making the booking).
     * - use: optional
     * @var bool
     */
    public $LeadCustomerInd;
    /**
     * Constructor method for PkgPassengerListItem
     * @uses PkgPassengerListItem::setName()
     * @uses PkgPassengerListItem::setSpecialNeed()
     * @uses PkgPassengerListItem::setPassportInformation()
     * @uses PkgPassengerListItem::setRPH()
     * @uses PkgPassengerListItem::setInsuranceRPH()
     * @uses PkgPassengerListItem::setNationality()
     * @uses PkgPassengerListItem::setLeadCustomerInd()
     * @param mixed $name
     * @param \StructType\SpecialNeed[] $specialNeed
     * @param mixed $passportInformation
     * @param string $rPH
     * @param string $insuranceRPH
     * @param string $nationality
     * @param bool $leadCustomerInd
     */
    public function __construct($name = null, array $specialNeed = array(), $passportInformation = null, $rPH = null, $insuranceRPH = null, $nationality = null, $leadCustomerInd = null)
    {
        $this
            ->setName($name)
            ->setSpecialNeed($specialNeed)
            ->setPassportInformation($passportInformation)
            ->setRPH($rPH)
            ->setInsuranceRPH($insuranceRPH)
            ->setNationality($nationality)
            ->setLeadCustomerInd($leadCustomerInd);
    }
    /**
     * Get Name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param mixed $name
     * @return \StructType\PkgPassengerListItem
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SpecialNeed value
     * @return \StructType\SpecialNeed[]|null
     */
    public function getSpecialNeed()
    {
        return $this->SpecialNeed;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialNeed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialNeed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialNeedForArrayConstraintsFromSetSpecialNeed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pkgPassengerListItemSpecialNeedItem) {
            // validation for constraint: itemType
            if (!$pkgPassengerListItemSpecialNeedItem instanceof \StructType\SpecialNeed) {
                $invalidValues[] = is_object($pkgPassengerListItemSpecialNeedItem) ? get_class($pkgPassengerListItemSpecialNeedItem) : sprintf('%s(%s)', gettype($pkgPassengerListItemSpecialNeedItem), var_export($pkgPassengerListItemSpecialNeedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialNeed property can only contain items of type \StructType\SpecialNeed, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialNeed[] $specialNeed
     * @return \StructType\PkgPassengerListItem
     */
    public function setSpecialNeed(array $specialNeed = array())
    {
        // validation for constraint: array
        if ('' !== ($specialNeedArrayErrorMessage = self::validateSpecialNeedForArrayConstraintsFromSetSpecialNeed($specialNeed))) {
            throw new \InvalidArgumentException($specialNeedArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specialNeed) && count($specialNeed) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specialNeed)), __LINE__);
        }
        $this->SpecialNeed = $specialNeed;
        return $this;
    }
    /**
     * Add item to SpecialNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialNeed $item
     * @return \StructType\PkgPassengerListItem
     */
    public function addToSpecialNeed(\StructType\SpecialNeed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialNeed) {
            throw new \InvalidArgumentException(sprintf('The SpecialNeed property can only contain items of type \StructType\SpecialNeed, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecialNeed) && count($this->SpecialNeed) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecialNeed)), __LINE__);
        }
        $this->SpecialNeed[] = $item;
        return $this;
    }
    /**
     * Get PassportInformation value
     * @return mixed|null
     */
    public function getPassportInformation()
    {
        return $this->PassportInformation;
    }
    /**
     * Set PassportInformation value
     * @param mixed $passportInformation
     * @return \StructType\PkgPassengerListItem
     */
    public function setPassportInformation($passportInformation = null)
    {
        $this->PassportInformation = $passportInformation;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PkgPassengerListItem
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InsuranceRPH value
     * @return string|null
     */
    public function getInsuranceRPH()
    {
        return $this->InsuranceRPH;
    }
    /**
     * Set InsuranceRPH value
     * @param string $insuranceRPH
     * @return \StructType\PkgPassengerListItem
     */
    public function setInsuranceRPH($insuranceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceRPH) && !is_string($insuranceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceRPH, true), gettype($insuranceRPH)), __LINE__);
        }
        $this->InsuranceRPH = $insuranceRPH;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\PkgPassengerListItem
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get LeadCustomerInd value
     * @return bool|null
     */
    public function getLeadCustomerInd()
    {
        return $this->LeadCustomerInd;
    }
    /**
     * Set LeadCustomerInd value
     * @param bool $leadCustomerInd
     * @return \StructType\PkgPassengerListItem
     */
    public function setLeadCustomerInd($leadCustomerInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($leadCustomerInd) && !is_bool($leadCustomerInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leadCustomerInd, true), gettype($leadCustomerInd)), __LINE__);
        }
        $this->LeadCustomerInd = $leadCustomerInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgPassengerListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
