<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PkgFlightSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides details for an air segment in a response message.
 * @subpackage Structs
 */
class PkgFlightSegmentType extends PkgFlightSegmentBaseType
{
    /**
     * The CabinAvailability
     * Meta information extracted from the WSDL
     * - documentation: Identifies a section of an aircraft, possibly providing extra services.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CabinAvailability;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The DepartureDay
     * Meta information extracted from the WSDL
     * - documentation: Specifies the day on which the flight departs.
     * - use: optional
     * @var string
     */
    public $DepartureDay;
    /**
     * The TravelCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the travel arrangement for the package
     * - use: optional
     * @var mixed
     */
    public $TravelCode;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: A length of time.
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The DirectionInd
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether travel is: one way, return trip, circle trip, open jaw, other
     * - use: optional
     * @var string
     */
    public $DirectionInd;
    /**
     * The CheckInDate
     * Meta information extracted from the WSDL
     * - documentation: Provides the recommended date and time of passenger check-in.
     * - use: optional
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckInDesk
     * Meta information extracted from the WSDL
     * - documentation: Identifies the desk or desks at which the customer will check-in and optionally the handling company operating the check-in service.
     * - use: optional
     * @var string
     */
    public $CheckInDesk;
    /**
     * The TOD_Indicator
     * Meta information extracted from the WSDL
     * - documentation: When 'true', the ticket(s) must be picked up at the airport, usually on the date of departure. When 'false', the tickets will be delivered according to the normal fulfilment arrangements e.g. by post or as an e-ticket.
     * - use: optional
     * @var bool
     */
    public $TOD_Indicator;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - documentation: The type of the ticket, e.g. paper or e-ticket.
     * - use: optional
     * @var string
     */
    public $TicketType;
    /**
     * Constructor method for PkgFlightSegmentType
     * @uses PkgFlightSegmentType::setCabinAvailability()
     * @uses PkgFlightSegmentType::setType()
     * @uses PkgFlightSegmentType::setDepartureDay()
     * @uses PkgFlightSegmentType::setTravelCode()
     * @uses PkgFlightSegmentType::setDuration()
     * @uses PkgFlightSegmentType::setDirectionInd()
     * @uses PkgFlightSegmentType::setCheckInDate()
     * @uses PkgFlightSegmentType::setCheckInDesk()
     * @uses PkgFlightSegmentType::setTOD_Indicator()
     * @uses PkgFlightSegmentType::setTicketType()
     * @param mixed[] $cabinAvailability
     * @param string $type
     * @param string $departureDay
     * @param mixed $travelCode
     * @param string $duration
     * @param string $directionInd
     * @param string $checkInDate
     * @param string $checkInDesk
     * @param bool $tOD_Indicator
     * @param string $ticketType
     */
    public function __construct(array $cabinAvailability = array(), $type = null, $departureDay = null, $travelCode = null, $duration = null, $directionInd = null, $checkInDate = null, $checkInDesk = null, $tOD_Indicator = null, $ticketType = null)
    {
        $this
            ->setCabinAvailability($cabinAvailability)
            ->setType($type)
            ->setDepartureDay($departureDay)
            ->setTravelCode($travelCode)
            ->setDuration($duration)
            ->setDirectionInd($directionInd)
            ->setCheckInDate($checkInDate)
            ->setCheckInDesk($checkInDesk)
            ->setTOD_Indicator($tOD_Indicator)
            ->setTicketType($ticketType);
    }
    /**
     * Get CabinAvailability value
     * @return mixed[]|null
     */
    public function getCabinAvailability()
    {
        return $this->CabinAvailability;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinAvailabilityForArrayConstraintsFromSetCabinAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pkgFlightSegmentTypeCabinAvailabilityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($pkgFlightSegmentTypeCabinAvailabilityItem) ? get_class($pkgFlightSegmentTypeCabinAvailabilityItem) : sprintf('%s(%s)', gettype($pkgFlightSegmentTypeCabinAvailabilityItem), var_export($pkgFlightSegmentTypeCabinAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinAvailability property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinAvailability value
     * @throws \InvalidArgumentException
     * @param mixed[] $cabinAvailability
     * @return \StructType\PkgFlightSegmentType
     */
    public function setCabinAvailability(array $cabinAvailability = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinAvailabilityArrayErrorMessage = self::validateCabinAvailabilityForArrayConstraintsFromSetCabinAvailability($cabinAvailability))) {
            throw new \InvalidArgumentException($cabinAvailabilityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($cabinAvailability) && count($cabinAvailability) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($cabinAvailability)), __LINE__);
        }
        $this->CabinAvailability = $cabinAvailability;
        return $this;
    }
    /**
     * Add item to CabinAvailability value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PkgFlightSegmentType
     */
    public function addToCabinAvailability($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CabinAvailability property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CabinAvailability) && count($this->CabinAvailability) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CabinAvailability)), __LINE__);
        }
        $this->CabinAvailability[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PkgFlightSegmentType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DepartureDay value
     * @return string|null
     */
    public function getDepartureDay()
    {
        return $this->DepartureDay;
    }
    /**
     * Set DepartureDay value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureDay
     * @return \StructType\PkgFlightSegmentType
     */
    public function setDepartureDay($departureDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($departureDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($departureDay) ? implode(', ', $departureDay) : var_export($departureDay, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DepartureDay = $departureDay;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return mixed|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param mixed $travelCode
     * @return \StructType\PkgFlightSegmentType
     */
    public function setTravelCode($travelCode = null)
    {
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\PkgFlightSegmentType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get DirectionInd value
     * @return string|null
     */
    public function getDirectionInd()
    {
        return $this->DirectionInd;
    }
    /**
     * Set DirectionInd value
     * @uses \EnumType\AirTripType::valueIsValid()
     * @uses \EnumType\AirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionInd
     * @return \StructType\PkgFlightSegmentType
     */
    public function setDirectionInd($directionInd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTripType::valueIsValid($directionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTripType', is_array($directionInd) ? implode(', ', $directionInd) : var_export($directionInd, true), implode(', ', \EnumType\AirTripType::getValidValues())), __LINE__);
        }
        $this->DirectionInd = $directionInd;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\PkgFlightSegmentType
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CheckInDesk value
     * @return string|null
     */
    public function getCheckInDesk()
    {
        return $this->CheckInDesk;
    }
    /**
     * Set CheckInDesk value
     * @param string $checkInDesk
     * @return \StructType\PkgFlightSegmentType
     */
    public function setCheckInDesk($checkInDesk = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDesk) && !is_string($checkInDesk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDesk, true), gettype($checkInDesk)), __LINE__);
        }
        $this->CheckInDesk = $checkInDesk;
        return $this;
    }
    /**
     * Get TOD_Indicator value
     * @return bool|null
     */
    public function getTOD_Indicator()
    {
        return $this->TOD_Indicator;
    }
    /**
     * Set TOD_Indicator value
     * @param bool $tOD_Indicator
     * @return \StructType\PkgFlightSegmentType
     */
    public function setTOD_Indicator($tOD_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($tOD_Indicator) && !is_bool($tOD_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tOD_Indicator, true), gettype($tOD_Indicator)), __LINE__);
        }
        $this->TOD_Indicator = $tOD_Indicator;
        return $this;
    }
    /**
     * Get TicketType value
     * @return string|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \StructType\PkgFlightSegmentType
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TicketType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PkgFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
