<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupReturnRules StructType
 * Meta information extracted from the WSDL
 * - documentation: Pickup and return requirements for a specific rate.
 * @subpackage Structs
 */
class PickupReturnRules extends AbstractStructBase
{
    /**
     * The EarliestPickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EarliestPickup
     */
    public $EarliestPickup;
    /**
     * The LatestPickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LatestPickup
     */
    public $LatestPickup;
    /**
     * The LatestReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LatestReturn
     */
    public $LatestReturn;
    /**
     * The EarliestReturn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EarliestReturn
     */
    public $EarliestReturn;
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - documentation: The day of the week, this rule refers. If this attribute is used, each following element qualifies for this day.
     * - use: optional
     * @var string
     */
    public $DayOfWeek;
    /**
     * The MinimumKeep
     * Meta information extracted from the WSDL
     * - documentation: The minimum time (e.g., number of rental days, number of rental hours) required to qualify for a specific rate.
     * - use: optional
     * @var string
     */
    public $MinimumKeep;
    /**
     * The MaximumKeep
     * Meta information extracted from the WSDL
     * - documentation: The maximum time (e.g., number of rental days, number of rental hours) allowed to qualify for a specific rate.
     * - use: optional
     * @var string
     */
    public $MaximumKeep;
    /**
     * The MaximumRental
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of rental days a vehicle is allowed to be rented.
     * - use: optional
     * @var string
     */
    public $MaximumRental;
    /**
     * The OvernightInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the vehicle must be kept overnight.
     * - use: optional
     * @var bool
     */
    public $OvernightInd;
    /**
     * The ReturnAllowedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the vehicle may be returned on this day of the week.
     * - use: optional
     * @var bool
     */
    public $ReturnAllowedInd;
    /**
     * Constructor method for PickupReturnRules
     * @uses PickupReturnRules::setEarliestPickup()
     * @uses PickupReturnRules::setLatestPickup()
     * @uses PickupReturnRules::setLatestReturn()
     * @uses PickupReturnRules::setEarliestReturn()
     * @uses PickupReturnRules::setDayOfWeek()
     * @uses PickupReturnRules::setMinimumKeep()
     * @uses PickupReturnRules::setMaximumKeep()
     * @uses PickupReturnRules::setMaximumRental()
     * @uses PickupReturnRules::setOvernightInd()
     * @uses PickupReturnRules::setReturnAllowedInd()
     * @param \StructType\EarliestPickup $earliestPickup
     * @param \StructType\LatestPickup $latestPickup
     * @param \StructType\LatestReturn $latestReturn
     * @param \StructType\EarliestReturn $earliestReturn
     * @param string $dayOfWeek
     * @param string $minimumKeep
     * @param string $maximumKeep
     * @param string $maximumRental
     * @param bool $overnightInd
     * @param bool $returnAllowedInd
     */
    public function __construct(\StructType\EarliestPickup $earliestPickup = null, \StructType\LatestPickup $latestPickup = null, \StructType\LatestReturn $latestReturn = null, \StructType\EarliestReturn $earliestReturn = null, $dayOfWeek = null, $minimumKeep = null, $maximumKeep = null, $maximumRental = null, $overnightInd = null, $returnAllowedInd = null)
    {
        $this
            ->setEarliestPickup($earliestPickup)
            ->setLatestPickup($latestPickup)
            ->setLatestReturn($latestReturn)
            ->setEarliestReturn($earliestReturn)
            ->setDayOfWeek($dayOfWeek)
            ->setMinimumKeep($minimumKeep)
            ->setMaximumKeep($maximumKeep)
            ->setMaximumRental($maximumRental)
            ->setOvernightInd($overnightInd)
            ->setReturnAllowedInd($returnAllowedInd);
    }
    /**
     * Get EarliestPickup value
     * @return \StructType\EarliestPickup|null
     */
    public function getEarliestPickup()
    {
        return $this->EarliestPickup;
    }
    /**
     * Set EarliestPickup value
     * @param \StructType\EarliestPickup $earliestPickup
     * @return \StructType\PickupReturnRules
     */
    public function setEarliestPickup(\StructType\EarliestPickup $earliestPickup = null)
    {
        $this->EarliestPickup = $earliestPickup;
        return $this;
    }
    /**
     * Get LatestPickup value
     * @return \StructType\LatestPickup|null
     */
    public function getLatestPickup()
    {
        return $this->LatestPickup;
    }
    /**
     * Set LatestPickup value
     * @param \StructType\LatestPickup $latestPickup
     * @return \StructType\PickupReturnRules
     */
    public function setLatestPickup(\StructType\LatestPickup $latestPickup = null)
    {
        $this->LatestPickup = $latestPickup;
        return $this;
    }
    /**
     * Get LatestReturn value
     * @return \StructType\LatestReturn|null
     */
    public function getLatestReturn()
    {
        return $this->LatestReturn;
    }
    /**
     * Set LatestReturn value
     * @param \StructType\LatestReturn $latestReturn
     * @return \StructType\PickupReturnRules
     */
    public function setLatestReturn(\StructType\LatestReturn $latestReturn = null)
    {
        $this->LatestReturn = $latestReturn;
        return $this;
    }
    /**
     * Get EarliestReturn value
     * @return \StructType\EarliestReturn|null
     */
    public function getEarliestReturn()
    {
        return $this->EarliestReturn;
    }
    /**
     * Set EarliestReturn value
     * @param \StructType\EarliestReturn $earliestReturn
     * @return \StructType\PickupReturnRules
     */
    public function setEarliestReturn(\StructType\EarliestReturn $earliestReturn = null)
    {
        $this->EarliestReturn = $earliestReturn;
        return $this;
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfWeek
     * @return \StructType\PickupReturnRules
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($dayOfWeek) ? implode(', ', $dayOfWeek) : var_export($dayOfWeek, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get MinimumKeep value
     * @return string|null
     */
    public function getMinimumKeep()
    {
        return $this->MinimumKeep;
    }
    /**
     * Set MinimumKeep value
     * @param string $minimumKeep
     * @return \StructType\PickupReturnRules
     */
    public function setMinimumKeep($minimumKeep = null)
    {
        // validation for constraint: string
        if (!is_null($minimumKeep) && !is_string($minimumKeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumKeep, true), gettype($minimumKeep)), __LINE__);
        }
        $this->MinimumKeep = $minimumKeep;
        return $this;
    }
    /**
     * Get MaximumKeep value
     * @return string|null
     */
    public function getMaximumKeep()
    {
        return $this->MaximumKeep;
    }
    /**
     * Set MaximumKeep value
     * @param string $maximumKeep
     * @return \StructType\PickupReturnRules
     */
    public function setMaximumKeep($maximumKeep = null)
    {
        // validation for constraint: string
        if (!is_null($maximumKeep) && !is_string($maximumKeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumKeep, true), gettype($maximumKeep)), __LINE__);
        }
        $this->MaximumKeep = $maximumKeep;
        return $this;
    }
    /**
     * Get MaximumRental value
     * @return string|null
     */
    public function getMaximumRental()
    {
        return $this->MaximumRental;
    }
    /**
     * Set MaximumRental value
     * @param string $maximumRental
     * @return \StructType\PickupReturnRules
     */
    public function setMaximumRental($maximumRental = null)
    {
        // validation for constraint: string
        if (!is_null($maximumRental) && !is_string($maximumRental)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumRental, true), gettype($maximumRental)), __LINE__);
        }
        $this->MaximumRental = $maximumRental;
        return $this;
    }
    /**
     * Get OvernightInd value
     * @return bool|null
     */
    public function getOvernightInd()
    {
        return $this->OvernightInd;
    }
    /**
     * Set OvernightInd value
     * @param bool $overnightInd
     * @return \StructType\PickupReturnRules
     */
    public function setOvernightInd($overnightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($overnightInd) && !is_bool($overnightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overnightInd, true), gettype($overnightInd)), __LINE__);
        }
        $this->OvernightInd = $overnightInd;
        return $this;
    }
    /**
     * Get ReturnAllowedInd value
     * @return bool|null
     */
    public function getReturnAllowedInd()
    {
        return $this->ReturnAllowedInd;
    }
    /**
     * Set ReturnAllowedInd value
     * @param bool $returnAllowedInd
     * @return \StructType\PickupReturnRules
     */
    public function setReturnAllowedInd($returnAllowedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnAllowedInd) && !is_bool($returnAllowedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnAllowedInd, true), gettype($returnAllowedInd)), __LINE__);
        }
        $this->ReturnAllowedInd = $returnAllowedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickupReturnRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
