<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PetsPolicy StructType
 * Meta information extracted from the WSDL
 * - documentation: This is used to designate the maximum pet weight and unit of weight measure (e.g., pounds or kilograms). | Detailed policy information when Pets are Allowed.
 * @subpackage Structs
 */
class PetsPolicy extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: A description of the pet policy.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The PetsPolicyCode
     * Meta information extracted from the WSDL
     * - documentation: Use OpenTravel Code Table Pet Policy Code list (PET).
     * - use: optional
     * @var string
     */
    public $PetsPolicyCode;
    /**
     * The MaxPetQuantity
     * Meta information extracted from the WSDL
     * - documentation: Maximum Number of Pets allowed in the accommodation provided.
     * - use: optional
     * @var int
     */
    public $MaxPetQuantity;
    /**
     * The RefundableDeposit
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $RefundableDeposit;
    /**
     * The NonRefundableFee
     * Meta information extracted from the WSDL
     * - documentation: Specifies the charge associated with a pet staying in the room.
     * - use: optional
     * @var float
     */
    public $NonRefundableFee;
    /**
     * The ChargeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to provide charge information for a pet. Refer to OpenTravel Code list Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $ChargeCode;
    /**
     * The RestrictionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, there is a restriction associated with this pet policy. When false, there is not a restriction associated with this pet policy.
     * - use: optional
     * @var bool
     */
    public $RestrictionInd;
    /**
     * The MinUnitOfMeasureQuantity
     * Meta information extracted from the WSDL
     * - documentation: This is used to designate the minimum pet weight allowed. The unit of measure code may indicate the associated unit of weight measure (e.g., pounds or kilograms).
     * - use: optional
     * @var float
     */
    public $MinUnitOfMeasureQuantity;
    /**
     * Constructor method for PetsPolicy
     * @uses PetsPolicy::setDescription()
     * @uses PetsPolicy::setPetsPolicyCode()
     * @uses PetsPolicy::setMaxPetQuantity()
     * @uses PetsPolicy::setRefundableDeposit()
     * @uses PetsPolicy::setNonRefundableFee()
     * @uses PetsPolicy::setChargeCode()
     * @uses PetsPolicy::setRestrictionInd()
     * @uses PetsPolicy::setMinUnitOfMeasureQuantity()
     * @param mixed[] $description
     * @param string $petsPolicyCode
     * @param int $maxPetQuantity
     * @param float $refundableDeposit
     * @param float $nonRefundableFee
     * @param string $chargeCode
     * @param bool $restrictionInd
     * @param float $minUnitOfMeasureQuantity
     */
    public function __construct(array $description = array(), $petsPolicyCode = null, $maxPetQuantity = null, $refundableDeposit = null, $nonRefundableFee = null, $chargeCode = null, $restrictionInd = null, $minUnitOfMeasureQuantity = null)
    {
        $this
            ->setDescription($description)
            ->setPetsPolicyCode($petsPolicyCode)
            ->setMaxPetQuantity($maxPetQuantity)
            ->setRefundableDeposit($refundableDeposit)
            ->setNonRefundableFee($nonRefundableFee)
            ->setChargeCode($chargeCode)
            ->setRestrictionInd($restrictionInd)
            ->setMinUnitOfMeasureQuantity($minUnitOfMeasureQuantity);
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $petsPolicyDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($petsPolicyDescriptionItem) ? get_class($petsPolicyDescriptionItem) : sprintf('%s(%s)', gettype($petsPolicyDescriptionItem), var_export($petsPolicyDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\PetsPolicy
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PetsPolicy
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get PetsPolicyCode value
     * @return string|null
     */
    public function getPetsPolicyCode()
    {
        return $this->PetsPolicyCode;
    }
    /**
     * Set PetsPolicyCode value
     * @param string $petsPolicyCode
     * @return \StructType\PetsPolicy
     */
    public function setPetsPolicyCode($petsPolicyCode = null)
    {
        // validation for constraint: string
        if (!is_null($petsPolicyCode) && !is_string($petsPolicyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($petsPolicyCode, true), gettype($petsPolicyCode)), __LINE__);
        }
        $this->PetsPolicyCode = $petsPolicyCode;
        return $this;
    }
    /**
     * Get MaxPetQuantity value
     * @return int|null
     */
    public function getMaxPetQuantity()
    {
        return $this->MaxPetQuantity;
    }
    /**
     * Set MaxPetQuantity value
     * @param int $maxPetQuantity
     * @return \StructType\PetsPolicy
     */
    public function setMaxPetQuantity($maxPetQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxPetQuantity) && !(is_int($maxPetQuantity) || ctype_digit($maxPetQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPetQuantity, true), gettype($maxPetQuantity)), __LINE__);
        }
        $this->MaxPetQuantity = $maxPetQuantity;
        return $this;
    }
    /**
     * Get RefundableDeposit value
     * @return float|null
     */
    public function getRefundableDeposit()
    {
        return $this->RefundableDeposit;
    }
    /**
     * Set RefundableDeposit value
     * @param float $refundableDeposit
     * @return \StructType\PetsPolicy
     */
    public function setRefundableDeposit($refundableDeposit = null)
    {
        // validation for constraint: float
        if (!is_null($refundableDeposit) && !(is_float($refundableDeposit) || is_numeric($refundableDeposit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundableDeposit, true), gettype($refundableDeposit)), __LINE__);
        }
        $this->RefundableDeposit = $refundableDeposit;
        return $this;
    }
    /**
     * Get NonRefundableFee value
     * @return float|null
     */
    public function getNonRefundableFee()
    {
        return $this->NonRefundableFee;
    }
    /**
     * Set NonRefundableFee value
     * @param float $nonRefundableFee
     * @return \StructType\PetsPolicy
     */
    public function setNonRefundableFee($nonRefundableFee = null)
    {
        // validation for constraint: float
        if (!is_null($nonRefundableFee) && !(is_float($nonRefundableFee) || is_numeric($nonRefundableFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonRefundableFee, true), gettype($nonRefundableFee)), __LINE__);
        }
        $this->NonRefundableFee = $nonRefundableFee;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \StructType\PetsPolicy
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCode, true), gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get RestrictionInd value
     * @return bool|null
     */
    public function getRestrictionInd()
    {
        return $this->RestrictionInd;
    }
    /**
     * Set RestrictionInd value
     * @param bool $restrictionInd
     * @return \StructType\PetsPolicy
     */
    public function setRestrictionInd($restrictionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictionInd) && !is_bool($restrictionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictionInd, true), gettype($restrictionInd)), __LINE__);
        }
        $this->RestrictionInd = $restrictionInd;
        return $this;
    }
    /**
     * Get MinUnitOfMeasureQuantity value
     * @return float|null
     */
    public function getMinUnitOfMeasureQuantity()
    {
        return $this->MinUnitOfMeasureQuantity;
    }
    /**
     * Set MinUnitOfMeasureQuantity value
     * @param float $minUnitOfMeasureQuantity
     * @return \StructType\PetsPolicy
     */
    public function setMinUnitOfMeasureQuantity($minUnitOfMeasureQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($minUnitOfMeasureQuantity) && !(is_float($minUnitOfMeasureQuantity) || is_numeric($minUnitOfMeasureQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minUnitOfMeasureQuantity, true), gettype($minUnitOfMeasureQuantity)), __LINE__);
        }
        $this->MinUnitOfMeasureQuantity = $minUnitOfMeasureQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PetsPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
