<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PetsPolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: Property pet policies.
 * @subpackage Structs
 */
class PetsPolicies extends AbstractStructBase
{
    /**
     * The PetsPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PetsPolicy[]
     */
    public $PetsPolicy;
    /**
     * The PetsAllowedCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PetsAllowedCode;
    /**
     * Constructor method for PetsPolicies
     * @uses PetsPolicies::setPetsPolicy()
     * @uses PetsPolicies::setPetsAllowedCode()
     * @param \StructType\PetsPolicy[] $petsPolicy
     * @param string $petsAllowedCode
     */
    public function __construct(array $petsPolicy = array(), $petsAllowedCode = null)
    {
        $this
            ->setPetsPolicy($petsPolicy)
            ->setPetsAllowedCode($petsAllowedCode);
    }
    /**
     * Get PetsPolicy value
     * @return \StructType\PetsPolicy[]|null
     */
    public function getPetsPolicy()
    {
        return $this->PetsPolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setPetsPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetsPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetsPolicyForArrayConstraintsFromSetPetsPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $petsPoliciesPetsPolicyItem) {
            // validation for constraint: itemType
            if (!$petsPoliciesPetsPolicyItem instanceof \StructType\PetsPolicy) {
                $invalidValues[] = is_object($petsPoliciesPetsPolicyItem) ? get_class($petsPoliciesPetsPolicyItem) : sprintf('%s(%s)', gettype($petsPoliciesPetsPolicyItem), var_export($petsPoliciesPetsPolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetsPolicy property can only contain items of type \StructType\PetsPolicy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\PetsPolicy[] $petsPolicy
     * @return \StructType\PetsPolicies
     */
    public function setPetsPolicy(array $petsPolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($petsPolicyArrayErrorMessage = self::validatePetsPolicyForArrayConstraintsFromSetPetsPolicy($petsPolicy))) {
            throw new \InvalidArgumentException($petsPolicyArrayErrorMessage, __LINE__);
        }
        $this->PetsPolicy = $petsPolicy;
        return $this;
    }
    /**
     * Add item to PetsPolicy value
     * @throws \InvalidArgumentException
     * @param \StructType\PetsPolicy $item
     * @return \StructType\PetsPolicies
     */
    public function addToPetsPolicy(\StructType\PetsPolicy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PetsPolicy) {
            throw new \InvalidArgumentException(sprintf('The PetsPolicy property can only contain items of type \StructType\PetsPolicy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetsPolicy[] = $item;
        return $this;
    }
    /**
     * Get PetsAllowedCode value
     * @return string|null
     */
    public function getPetsAllowedCode()
    {
        return $this->PetsAllowedCode;
    }
    /**
     * Set PetsAllowedCode value
     * @param string $petsAllowedCode
     * @return \StructType\PetsPolicies
     */
    public function setPetsAllowedCode($petsAllowedCode = null)
    {
        // validation for constraint: string
        if (!is_null($petsAllowedCode) && !is_string($petsAllowedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($petsAllowedCode, true), gettype($petsAllowedCode)), __LINE__);
        }
        $this->PetsAllowedCode = $petsAllowedCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PetsPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
