<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonalInsuranceItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the number of customers taking specific type of personal insurance.
 * @subpackage Structs
 */
class PersonalInsuranceItemType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The CustomerCounts
     * Meta information extracted from the WSDL
     * - documentation: Counts of the number of passengers in age categories. Used when individual passenger identification is not required.
     * @var mixed
     */
    public $CustomerCounts;
    /**
     * Constructor method for PersonalInsuranceItemType
     * @uses PersonalInsuranceItemType::setCode()
     * @uses PersonalInsuranceItemType::setCustomerCounts()
     * @param string $code
     * @param mixed $customerCounts
     */
    public function __construct($code = null, $customerCounts = null)
    {
        $this
            ->setCode($code)
            ->setCustomerCounts($customerCounts);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\PkgPersonalInsuranceCode::valueIsValid()
     * @uses \EnumType\PkgPersonalInsuranceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\PersonalInsuranceItemType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PkgPersonalInsuranceCode::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PkgPersonalInsuranceCode', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\PkgPersonalInsuranceCode::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CustomerCounts value
     * @return mixed|null
     */
    public function getCustomerCounts()
    {
        return $this->CustomerCounts;
    }
    /**
     * Set CustomerCounts value
     * @param mixed $customerCounts
     * @return \StructType\PersonalInsuranceItemType
     */
    public function setCustomerCounts($customerCounts = null)
    {
        $this->CustomerCounts = $customerCounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonalInsuranceItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
