<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of person name data between parties. | This provides name information for a person.
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - documentation: Salutation of honorific (e.g. Mr., Mrs., Ms., Miss, Dr.)
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Given name, first name or names.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: The middle name of the person name.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta information extracted from the WSDL
     * - documentation: The surname prefix, e.g "van der", "von", "de".
     * - minOccurs: 0
     * @var mixed
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Family name, last name. May also be used for full name if the sending system does not have the ability to separate a full name into its parts, e.g. the surname element may be used to pass the full name.
     * @var mixed
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - documentation: Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.)
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta information extracted from the WSDL
     * - documentation: Degree or honors (e.g., Ph.D., M.D.)
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NameTitle;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $Document;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The NameType
     * Meta information extracted from the WSDL
     * - documentation: Type of name of the individual, such as former, nickname, alternate or alias name. Refer to OpenTravel Code List Name Type (NAM).
     * - use: optional
     * @var string
     */
    public $NameType;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This represents which language the name is represented in, e.g. an Eastern name versus a Western name. | Example: en | Name representation language.
     * @var string
     */
    public $Language;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, this is the default or primary name within a collection of names. | Example: true | Primary name indicator.
     * @var bool
     */
    public $DefaultInd;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setDocument()
     * @uses PersonNameType::setTPA_Extensions()
     * @uses PersonNameType::setNameType()
     * @uses PersonNameType::setLanguage()
     * @uses PersonNameType::setDefaultInd()
     * @param mixed[] $namePrefix
     * @param mixed[] $givenName
     * @param mixed[] $middleName
     * @param mixed $surnamePrefix
     * @param mixed $surname
     * @param mixed[] $nameSuffix
     * @param mixed[] $nameTitle
     * @param \StructType\Document $document
     * @param mixed $tPA_Extensions
     * @param string $nameType
     * @param string $language
     * @param bool $defaultInd
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), \StructType\Document $document = null, $tPA_Extensions = null, $nameType = null, $language = null, $defaultInd = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setDocument($document)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNameType($nameType)
            ->setLanguage($language)
            ->setDefaultInd($defaultInd);
    }
    /**
     * Get NamePrefix value
     * @return mixed[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * This method is responsible for validating the values passed to the setNamePrefix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePrefix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefixForArrayConstraintsFromSetNamePrefix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNamePrefixItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($personNameTypeNamePrefixItem) ? get_class($personNameTypeNamePrefixItem) : sprintf('%s(%s)', gettype($personNameTypeNamePrefixItem), var_export($personNameTypeNamePrefixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamePrefix property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamePrefix value
     * @throws \InvalidArgumentException
     * @param mixed[] $namePrefix
     * @return \StructType\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        // validation for constraint: array
        if ('' !== ($namePrefixArrayErrorMessage = self::validateNamePrefixForArrayConstraintsFromSetNamePrefix($namePrefix))) {
            throw new \InvalidArgumentException($namePrefixArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($namePrefix) && count($namePrefix) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($namePrefix)), __LINE__);
        }
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The NamePrefix property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->NamePrefix) && count($this->NamePrefix) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->NamePrefix)), __LINE__);
        }
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return mixed[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeGivenNameItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($personNameTypeGivenNameItem) ? get_class($personNameTypeGivenNameItem) : sprintf('%s(%s)', gettype($personNameTypeGivenNameItem), var_export($personNameTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param mixed[] $givenName
     * @return \StructType\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PersonNameType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return mixed[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($personNameTypeMiddleNameItem) ? get_class($personNameTypeMiddleNameItem) : sprintf('%s(%s)', gettype($personNameTypeMiddleNameItem), var_export($personNameTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param mixed[] $middleName
     * @return \StructType\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PersonNameType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return mixed|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param mixed $surnamePrefix
     * @return \StructType\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return mixed|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param mixed $surname
     * @return \StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return mixed[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * This method is responsible for validating the values passed to the setNameSuffix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameSuffix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameSuffixForArrayConstraintsFromSetNameSuffix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameSuffixItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($personNameTypeNameSuffixItem) ? get_class($personNameTypeNameSuffixItem) : sprintf('%s(%s)', gettype($personNameTypeNameSuffixItem), var_export($personNameTypeNameSuffixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameSuffix property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameSuffix value
     * @throws \InvalidArgumentException
     * @param mixed[] $nameSuffix
     * @return \StructType\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        // validation for constraint: array
        if ('' !== ($nameSuffixArrayErrorMessage = self::validateNameSuffixForArrayConstraintsFromSetNameSuffix($nameSuffix))) {
            throw new \InvalidArgumentException($nameSuffixArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($nameSuffix) && count($nameSuffix) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($nameSuffix)), __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The NameSuffix property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->NameSuffix) && count($this->NameSuffix) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->NameSuffix)), __LINE__);
        }
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return mixed[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * This method is responsible for validating the values passed to the setNameTitle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNameTitle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameTitleForArrayConstraintsFromSetNameTitle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personNameTypeNameTitleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($personNameTypeNameTitleItem) ? get_class($personNameTypeNameTitleItem) : sprintf('%s(%s)', gettype($personNameTypeNameTitleItem), var_export($personNameTypeNameTitleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NameTitle property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NameTitle value
     * @throws \InvalidArgumentException
     * @param mixed[] $nameTitle
     * @return \StructType\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        // validation for constraint: array
        if ('' !== ($nameTitleArrayErrorMessage = self::validateNameTitleForArrayConstraintsFromSetNameTitle($nameTitle))) {
            throw new \InvalidArgumentException($nameTitleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($nameTitle) && count($nameTitle) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($nameTitle)), __LINE__);
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PersonNameType
     */
    public function addToNameTitle($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The NameTitle property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->NameTitle) && count($this->NameTitle) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->NameTitle)), __LINE__);
        }
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\Document $document
     * @return \StructType\PersonNameType
     */
    public function setDocument(\StructType\Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\PersonNameType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \StructType\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        // validation for constraint: string
        if (!is_null($nameType) && !is_string($nameType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameType, true), gettype($nameType)), __LINE__);
        }
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\PersonNameType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\PersonNameType
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
