<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRulesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of payment rules.
 * @subpackage Structs
 */
class PaymentRulesType extends AbstractStructBase
{
    /**
     * The PaymentRule
     * Meta information extracted from the WSDL
     * - documentation: One specific payment rule associated with this reservation. For example, a date by which a deposit must be received.
     * - maxOccurs: 9
     * @var mixed[]
     */
    public $PaymentRule;
    /**
     * Constructor method for PaymentRulesType
     * @uses PaymentRulesType::setPaymentRule()
     * @param mixed[] $paymentRule
     */
    public function __construct(array $paymentRule = array())
    {
        $this
            ->setPaymentRule($paymentRule);
    }
    /**
     * Get PaymentRule value
     * @return mixed[]|null
     */
    public function getPaymentRule()
    {
        return $this->PaymentRule;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentRuleForArrayConstraintsFromSetPaymentRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRulesTypePaymentRuleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($paymentRulesTypePaymentRuleItem) ? get_class($paymentRulesTypePaymentRuleItem) : sprintf('%s(%s)', gettype($paymentRulesTypePaymentRuleItem), var_export($paymentRulesTypePaymentRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentRule property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentRule value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentRule
     * @return \StructType\PaymentRulesType
     */
    public function setPaymentRule(array $paymentRule = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentRuleArrayErrorMessage = self::validatePaymentRuleForArrayConstraintsFromSetPaymentRule($paymentRule))) {
            throw new \InvalidArgumentException($paymentRuleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentRule) && count($paymentRule) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentRule)), __LINE__);
        }
        $this->PaymentRule = $paymentRule;
        return $this;
    }
    /**
     * Add item to PaymentRule value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\PaymentRulesType
     */
    public function addToPaymentRule($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentRule) && count($this->PaymentRule) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentRule)), __LINE__);
        }
        $this->PaymentRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentRulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
