<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of payment choices.
 * @subpackage Structs
 */
class PaymentOptions extends AbstractStructBase
{
    /**
     * The PaymentOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\PaymentOption[]
     */
    public $PaymentOption;
    /**
     * Constructor method for PaymentOptions
     * @uses PaymentOptions::setPaymentOption()
     * @param \StructType\PaymentOption[] $paymentOption
     */
    public function __construct(array $paymentOption = array())
    {
        $this
            ->setPaymentOption($paymentOption);
    }
    /**
     * Get PaymentOption value
     * @return \StructType\PaymentOption[]|null
     */
    public function getPaymentOption()
    {
        return $this->PaymentOption;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentOptionForArrayConstraintsFromSetPaymentOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentOptionsPaymentOptionItem) {
            // validation for constraint: itemType
            if (!$paymentOptionsPaymentOptionItem instanceof \StructType\PaymentOption) {
                $invalidValues[] = is_object($paymentOptionsPaymentOptionItem) ? get_class($paymentOptionsPaymentOptionItem) : sprintf('%s(%s)', gettype($paymentOptionsPaymentOptionItem), var_export($paymentOptionsPaymentOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentOption property can only contain items of type \StructType\PaymentOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentOption value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentOption[] $paymentOption
     * @return \StructType\PaymentOptions
     */
    public function setPaymentOption(array $paymentOption = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentOptionArrayErrorMessage = self::validatePaymentOptionForArrayConstraintsFromSetPaymentOption($paymentOption))) {
            throw new \InvalidArgumentException($paymentOptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($paymentOption) && count($paymentOption) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($paymentOption)), __LINE__);
        }
        $this->PaymentOption = $paymentOption;
        return $this;
    }
    /**
     * Add item to PaymentOption value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentOption $item
     * @return \StructType\PaymentOptions
     */
    public function addToPaymentOption(\StructType\PaymentOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentOption) {
            throw new \InvalidArgumentException(sprintf('The PaymentOption property can only contain items of type \StructType\PaymentOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->PaymentOption) && count($this->PaymentOption) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->PaymentOption)), __LINE__);
        }
        $this->PaymentOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
