<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: The currency amount of the payment. | Provides the monetary amount due for payment as quoted. A second instance could show the actual paid amount in a different currency.
 * @subpackage Structs
 */
class PaymentAmount extends AbstractStructBase
{
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - documentation: The approval code returned as part of an authorization process.
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The RefundCalcMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RefundCalcMethod;
    /**
     * Constructor method for PaymentAmount
     * @uses PaymentAmount::setApprovalCode()
     * @uses PaymentAmount::setRefundCalcMethod()
     * @param string $approvalCode
     * @param string $refundCalcMethod
     */
    public function __construct($approvalCode = null, $refundCalcMethod = null)
    {
        $this
            ->setApprovalCode($approvalCode)
            ->setRefundCalcMethod($refundCalcMethod);
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \StructType\PaymentAmount
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get RefundCalcMethod value
     * @return string|null
     */
    public function getRefundCalcMethod()
    {
        return $this->RefundCalcMethod;
    }
    /**
     * Set RefundCalcMethod value
     * @param string $refundCalcMethod
     * @return \StructType\PaymentAmount
     */
    public function setRefundCalcMethod($refundCalcMethod = null)
    {
        // validation for constraint: string
        if (!is_null($refundCalcMethod) && !is_string($refundCalcMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundCalcMethod, true), gettype($refundCalcMethod)), __LINE__);
        }
        $this->RefundCalcMethod = $refundCalcMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
