<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify multiple currency amounts as well as payment types (e.g., deposit, final).
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The PaymentNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Payment Number. Typically would be used to indicate the deposit as well as the final payments as determined by the backend system.
     * - use: required
     * @var int
     */
    public $PaymentNumber;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Payment Due Date/Time.
     * - use: required
     * @var string
     */
    public $DueDate;
    /**
     * Constructor method for Payment
     * @uses Payment::setPaymentNumber()
     * @uses Payment::setDueDate()
     * @param int $paymentNumber
     * @param string $dueDate
     */
    public function __construct($paymentNumber = null, $dueDate = null)
    {
        $this
            ->setPaymentNumber($paymentNumber)
            ->setDueDate($dueDate);
    }
    /**
     * Get PaymentNumber value
     * @return int
     */
    public function getPaymentNumber()
    {
        return $this->PaymentNumber;
    }
    /**
     * Set PaymentNumber value
     * @param int $paymentNumber
     * @return \StructType\Payment
     */
    public function setPaymentNumber($paymentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($paymentNumber) && !(is_int($paymentNumber) || ctype_digit($paymentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentNumber, true), gettype($paymentNumber)), __LINE__);
        }
        $this->PaymentNumber = $paymentNumber;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \StructType\Payment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
