<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerQualifyingInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Age qualifying information for the passenger. Refer to OpenTravel code list Rail Passenger Type Code (PXC).
 * @subpackage Structs
 */
class PassengerQualifyingInfo extends AbstractStructBase
{
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for a passenger category that may be used to associate a passenger category elsewhere in this schema.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PassengerQualifyingInfo
     * @uses PassengerQualifyingInfo::setQuantity()
     * @uses PassengerQualifyingInfo::setRPH()
     * @param string $quantity
     * @param string $rPH
     */
    public function __construct($quantity = null, $rPH = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRPH($rPH);
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \StructType\PassengerQualifyingInfo
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PassengerQualifyingInfo
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerQualifyingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
