<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerCategory StructType
 * Meta information extracted from the WSDL
 * - documentation: Example: Disabled | Passenger category.
 * @subpackage Structs
 */
class PassengerCategory extends \EnumType\List_OfferPassengerType
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Example: 2 | Quantity.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The OtherType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $OtherType;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for PassengerCategory
     * @uses PassengerCategory::setQuantity()
     * @uses PassengerCategory::setOtherType()
     * @uses PassengerCategory::setOntologyRefID()
     * @param int $quantity
     * @param string $otherType
     * @param string $ontologyRefID
     */
    public function __construct($quantity = null, $otherType = null, $ontologyRefID = null)
    {
        $this
            ->setQuantity($quantity)
            ->setOtherType($otherType)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\PassengerCategory
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get OtherType value
     * @return string|null
     */
    public function getOtherType()
    {
        return $this->OtherType;
    }
    /**
     * Set OtherType value
     * @param string $otherType
     * @return \StructType\PassengerCategory
     */
    public function setOtherType($otherType = null)
    {
        // validation for constraint: string
        if (!is_null($otherType) && !is_string($otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherType, true), gettype($otherType)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($otherType) && !preg_match('/[a-zA-Z0-9]{1,64}/', $otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($otherType, true)), __LINE__);
        }
        $this->OtherType = $otherType;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\PassengerCategory
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
