<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of PartnerInfo.
 * @subpackage Structs
 */
class PartnerInfos extends AbstractStructBase
{
    /**
     * The PartnerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\PartnerInfo[]
     */
    public $PartnerInfo;
    /**
     * Constructor method for PartnerInfos
     * @uses PartnerInfos::setPartnerInfo()
     * @param \StructType\PartnerInfo[] $partnerInfo
     */
    public function __construct(array $partnerInfo = array())
    {
        $this
            ->setPartnerInfo($partnerInfo);
    }
    /**
     * Get PartnerInfo value
     * @return \StructType\PartnerInfo[]|null
     */
    public function getPartnerInfo()
    {
        return $this->PartnerInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPartnerInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartnerInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerInfoForArrayConstraintsFromSetPartnerInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partnerInfosPartnerInfoItem) {
            // validation for constraint: itemType
            if (!$partnerInfosPartnerInfoItem instanceof \StructType\PartnerInfo) {
                $invalidValues[] = is_object($partnerInfosPartnerInfoItem) ? get_class($partnerInfosPartnerInfoItem) : sprintf('%s(%s)', gettype($partnerInfosPartnerInfoItem), var_export($partnerInfosPartnerInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartnerInfo property can only contain items of type \StructType\PartnerInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartnerInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerInfo[] $partnerInfo
     * @return \StructType\PartnerInfos
     */
    public function setPartnerInfo(array $partnerInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerInfoArrayErrorMessage = self::validatePartnerInfoForArrayConstraintsFromSetPartnerInfo($partnerInfo))) {
            throw new \InvalidArgumentException($partnerInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($partnerInfo) && count($partnerInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($partnerInfo)), __LINE__);
        }
        $this->PartnerInfo = $partnerInfo;
        return $this;
    }
    /**
     * Add item to PartnerInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PartnerInfo $item
     * @return \StructType\PartnerInfos
     */
    public function addToPartnerInfo(\StructType\PartnerInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartnerInfo) {
            throw new \InvalidArgumentException(sprintf('The PartnerInfo property can only contain items of type \StructType\PartnerInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PartnerInfo) && count($this->PartnerInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PartnerInfo)), __LINE__);
        }
        $this->PartnerInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
