<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: The booking status of the reservation. | Specifies the number in party. | The start date and duration of the package. | The supplier's code to identify the travel arrangement for the package. | One line in a list of package
 * reservations. It contains the reservation id, departure date and point, destination point, duration, tour and travel codes, flight code, passenger name and number of passengers, and booking status.
 * @subpackage Structs
 */
class PackageReservation extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The package booking reference.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The surname, initial, and title of the passenger.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The ArrivalLocation
     * Meta information extracted from the WSDL
     * - documentation: The code for the final destination - normally an IATA code.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $ArrivalLocation;
    /**
     * The DepartureLocation
     * Meta information extracted from the WSDL
     * - documentation: The code for the traveller's departure point - normally an IATA code.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $DepartureLocation;
    /**
     * The TravelCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the travel arrangement for the package. | Used for Character Strings, length 1 to 8. | The supplier's code to identify the travel arrangement for the package
     * - base: StringLength1to8
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $TravelCode;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: The supplier's code to identify the accommodation/tour arrangement for a package.
     * - use: optional
     * @var string
     */
    public $TourCode;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - documentation: A code identifying a complete package arrangement, replacing individual travel and accommodation codes. | Used for Character Strings, length 1 to 32.
     * - base: StringLength1to32
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PackageID;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The ReservationStatusCode
     * @var string
     */
    public $ReservationStatusCode;
    /**
     * The ReservationStatus
     * @var string
     */
    public $ReservationStatus;
    /**
     * Constructor method for PackageReservation
     * @uses PackageReservation::setUniqueID()
     * @uses PackageReservation::setName()
     * @uses PackageReservation::setArrivalLocation()
     * @uses PackageReservation::setDepartureLocation()
     * @uses PackageReservation::setTravelCode()
     * @uses PackageReservation::setTourCode()
     * @uses PackageReservation::setPackageID()
     * @uses PackageReservation::setStart()
     * @uses PackageReservation::setDuration()
     * @uses PackageReservation::setEnd()
     * @uses PackageReservation::setQuantity()
     * @uses PackageReservation::setReservationStatusCode()
     * @uses PackageReservation::setReservationStatus()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\PersonNameType $name
     * @param \StructType\LocationType $arrivalLocation
     * @param \StructType\LocationType $departureLocation
     * @param string $travelCode
     * @param string $tourCode
     * @param string $packageID
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param int $quantity
     * @param string $reservationStatusCode
     * @param string $reservationStatus
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\PersonNameType $name = null, \StructType\LocationType $arrivalLocation = null, \StructType\LocationType $departureLocation = null, $travelCode = null, $tourCode = null, $packageID = null, $start = null, $duration = null, $end = null, $quantity = null, $reservationStatusCode = null, $reservationStatus = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setName($name)
            ->setArrivalLocation($arrivalLocation)
            ->setDepartureLocation($departureLocation)
            ->setTravelCode($travelCode)
            ->setTourCode($tourCode)
            ->setPackageID($packageID)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setQuantity($quantity)
            ->setReservationStatusCode($reservationStatusCode)
            ->setReservationStatus($reservationStatus);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\PackageReservation
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\PackageReservation
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ArrivalLocation value
     * @return \StructType\LocationType|null
     */
    public function getArrivalLocation()
    {
        return $this->ArrivalLocation;
    }
    /**
     * Set ArrivalLocation value
     * @param \StructType\LocationType $arrivalLocation
     * @return \StructType\PackageReservation
     */
    public function setArrivalLocation(\StructType\LocationType $arrivalLocation = null)
    {
        $this->ArrivalLocation = $arrivalLocation;
        return $this;
    }
    /**
     * Get DepartureLocation value
     * @return \StructType\LocationType|null
     */
    public function getDepartureLocation()
    {
        return $this->DepartureLocation;
    }
    /**
     * Set DepartureLocation value
     * @param \StructType\LocationType $departureLocation
     * @return \StructType\PackageReservation
     */
    public function setDepartureLocation(\StructType\LocationType $departureLocation = null)
    {
        $this->DepartureLocation = $departureLocation;
        return $this;
    }
    /**
     * Get TravelCode value
     * @return string|null
     */
    public function getTravelCode()
    {
        return $this->TravelCode;
    }
    /**
     * Set TravelCode value
     * @param string $travelCode
     * @return \StructType\PackageReservation
     */
    public function setTravelCode($travelCode = null)
    {
        // validation for constraint: string
        if (!is_null($travelCode) && !is_string($travelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelCode, true), gettype($travelCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($travelCode) && mb_strlen($travelCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($travelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($travelCode) && mb_strlen($travelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($travelCode)), __LINE__);
        }
        $this->TravelCode = $travelCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\PackageReservation
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \StructType\PackageReservation
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($packageID) && mb_strlen($packageID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($packageID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageID) && mb_strlen($packageID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\PackageReservation
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\PackageReservation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\PackageReservation
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\PackageReservation
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReservationStatusCode value
     * @return string|null
     */
    public function getReservationStatusCode()
    {
        return $this->ReservationStatusCode;
    }
    /**
     * Set ReservationStatusCode value
     * @param string $reservationStatusCode
     * @return \StructType\PackageReservation
     */
    public function setReservationStatusCode($reservationStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatusCode) && !is_string($reservationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationStatusCode, true), gettype($reservationStatusCode)), __LINE__);
        }
        $this->ReservationStatusCode = $reservationStatusCode;
        return $this;
    }
    /**
     * Get ReservationStatus value
     * @return string|null
     */
    public function getReservationStatus()
    {
        return $this->ReservationStatus;
    }
    /**
     * Set ReservationStatus value
     * @param string $reservationStatus
     * @return \StructType\PackageReservation
     */
    public function setReservationStatus($reservationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($reservationStatus) && !is_string($reservationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationStatus, true), gettype($reservationStatus)), __LINE__);
        }
        $this->ReservationStatus = $reservationStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
