<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OwnershipManagementInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of OwnershipManagementInfo.
 * @subpackage Structs
 */
class OwnershipManagementInfos extends AbstractStructBase
{
    /**
     * The OwnershipManagementInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\OwnershipManagementInfo[]
     */
    public $OwnershipManagementInfo;
    /**
     * Constructor method for OwnershipManagementInfos
     * @uses OwnershipManagementInfos::setOwnershipManagementInfo()
     * @param \StructType\OwnershipManagementInfo[] $ownershipManagementInfo
     */
    public function __construct(array $ownershipManagementInfo = array())
    {
        $this
            ->setOwnershipManagementInfo($ownershipManagementInfo);
    }
    /**
     * Get OwnershipManagementInfo value
     * @return \StructType\OwnershipManagementInfo[]|null
     */
    public function getOwnershipManagementInfo()
    {
        return $this->OwnershipManagementInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setOwnershipManagementInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOwnershipManagementInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOwnershipManagementInfoForArrayConstraintsFromSetOwnershipManagementInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ownershipManagementInfosOwnershipManagementInfoItem) {
            // validation for constraint: itemType
            if (!$ownershipManagementInfosOwnershipManagementInfoItem instanceof \StructType\OwnershipManagementInfo) {
                $invalidValues[] = is_object($ownershipManagementInfosOwnershipManagementInfoItem) ? get_class($ownershipManagementInfosOwnershipManagementInfoItem) : sprintf('%s(%s)', gettype($ownershipManagementInfosOwnershipManagementInfoItem), var_export($ownershipManagementInfosOwnershipManagementInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OwnershipManagementInfo property can only contain items of type \StructType\OwnershipManagementInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OwnershipManagementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OwnershipManagementInfo[] $ownershipManagementInfo
     * @return \StructType\OwnershipManagementInfos
     */
    public function setOwnershipManagementInfo(array $ownershipManagementInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($ownershipManagementInfoArrayErrorMessage = self::validateOwnershipManagementInfoForArrayConstraintsFromSetOwnershipManagementInfo($ownershipManagementInfo))) {
            throw new \InvalidArgumentException($ownershipManagementInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ownershipManagementInfo) && count($ownershipManagementInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ownershipManagementInfo)), __LINE__);
        }
        $this->OwnershipManagementInfo = $ownershipManagementInfo;
        return $this;
    }
    /**
     * Add item to OwnershipManagementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OwnershipManagementInfo $item
     * @return \StructType\OwnershipManagementInfos
     */
    public function addToOwnershipManagementInfo(\StructType\OwnershipManagementInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OwnershipManagementInfo) {
            throw new \InvalidArgumentException(sprintf('The OwnershipManagementInfo property can only contain items of type \StructType\OwnershipManagementInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OwnershipManagementInfo) && count($this->OwnershipManagementInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OwnershipManagementInfo)), __LINE__);
        }
        $this->OwnershipManagementInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OwnershipManagementInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
