<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherServiceInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Other Service Information (OSI) for relevant airlines
 * @subpackage Structs
 */
class OtherServiceInfoType extends AbstractStructBase
{
    /**
     * The TravelerRefNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: The airline to which the OSI applies. When applicable to all airlines or an unknown airline use Code="YY".
     * @var mixed
     */
    public $Airline;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: The OSI text.
     * @var mixed
     */
    public $Text;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A proprietary code used between systems to identify an Other Service Information (OSI) item.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * Constructor method for OtherServiceInfoType
     * @uses OtherServiceInfoType::setTravelerRefNumber()
     * @uses OtherServiceInfoType::setAirline()
     * @uses OtherServiceInfoType::setText()
     * @uses OtherServiceInfoType::setCode()
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param mixed $airline
     * @param mixed $text
     * @param string $code
     */
    public function __construct(array $travelerRefNumber = array(), $airline = null, $text = null, $code = null)
    {
        $this
            ->setTravelerRefNumber($travelerRefNumber)
            ->setAirline($airline)
            ->setText($text)
            ->setCode($code);
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelerRefNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelerRefNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherServiceInfoTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$otherServiceInfoTypeTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                $invalidValues[] = is_object($otherServiceInfoTypeTravelerRefNumberItem) ? get_class($otherServiceInfoTypeTravelerRefNumberItem) : sprintf('%s(%s)', gettype($otherServiceInfoTypeTravelerRefNumberItem), var_export($otherServiceInfoTypeTravelerRefNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\OtherServiceInfoType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($travelerRefNumberArrayErrorMessage = self::validateTravelerRefNumberForArrayConstraintsFromSetTravelerRefNumber($travelerRefNumber))) {
            throw new \InvalidArgumentException($travelerRefNumberArrayErrorMessage, __LINE__);
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\OtherServiceInfoType
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of type \StructType\TravelerRefNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Airline value
     * @return mixed|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param mixed $airline
     * @return \StructType\OtherServiceInfoType
     */
    public function setAirline($airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Text value
     * @return mixed|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param mixed $text
     * @return \StructType\OtherServiceInfoType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\OtherServiceInfoType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OtherServiceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
