<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Origin Location. | Travel Origin Location - for example, air uses the IATA 3 letter code.
 * @subpackage Structs
 */
class OriginLocation extends LocationType
{
    /**
     * The MultiAirportCityInd
     * Meta information extracted from the WSDL
     * - documentation: If true, other airports within this city may be considered (i.e., EWR, JFK when origin location is LGA.)
     * - use: optional
     * @var bool
     */
    public $MultiAirportCityInd;
    /**
     * The AlternateLocationInd
     * Meta information extracted from the WSDL
     * - documentation: If true, alternate locations may be considered.
     * - use: optional
     * @var bool
     */
    public $AlternateLocationInd;
    /**
     * The MultiCityStationInd
     * Meta information extracted from the WSDL
     * - documentation: If true, multiple train stations within a specified city or location code may be considered.
     * - use: optional
     * @var bool
     */
    public $MultiCityStationInd;
    /**
     * Constructor method for OriginLocation
     * @uses OriginLocation::setMultiAirportCityInd()
     * @uses OriginLocation::setAlternateLocationInd()
     * @uses OriginLocation::setMultiCityStationInd()
     * @param bool $multiAirportCityInd
     * @param bool $alternateLocationInd
     * @param bool $multiCityStationInd
     */
    public function __construct($multiAirportCityInd = null, $alternateLocationInd = null, $multiCityStationInd = null)
    {
        $this
            ->setMultiAirportCityInd($multiAirportCityInd)
            ->setAlternateLocationInd($alternateLocationInd)
            ->setMultiCityStationInd($multiCityStationInd);
    }
    /**
     * Get MultiAirportCityInd value
     * @return bool|null
     */
    public function getMultiAirportCityInd()
    {
        return $this->MultiAirportCityInd;
    }
    /**
     * Set MultiAirportCityInd value
     * @param bool $multiAirportCityInd
     * @return \StructType\OriginLocation
     */
    public function setMultiAirportCityInd($multiAirportCityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAirportCityInd) && !is_bool($multiAirportCityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiAirportCityInd, true), gettype($multiAirportCityInd)), __LINE__);
        }
        $this->MultiAirportCityInd = $multiAirportCityInd;
        return $this;
    }
    /**
     * Get AlternateLocationInd value
     * @return bool|null
     */
    public function getAlternateLocationInd()
    {
        return $this->AlternateLocationInd;
    }
    /**
     * Set AlternateLocationInd value
     * @param bool $alternateLocationInd
     * @return \StructType\OriginLocation
     */
    public function setAlternateLocationInd($alternateLocationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($alternateLocationInd) && !is_bool($alternateLocationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alternateLocationInd, true), gettype($alternateLocationInd)), __LINE__);
        }
        $this->AlternateLocationInd = $alternateLocationInd;
        return $this;
    }
    /**
     * Get MultiCityStationInd value
     * @return bool|null
     */
    public function getMultiCityStationInd()
    {
        return $this->MultiCityStationInd;
    }
    /**
     * Set MultiCityStationInd value
     * @param bool $multiCityStationInd
     * @return \StructType\OriginLocation
     */
    public function setMultiCityStationInd($multiCityStationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiCityStationInd) && !is_bool($multiCityStationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiCityStationInd, true), gettype($multiCityStationInd)), __LINE__);
        }
        $this->MultiCityStationInd = $multiCityStationInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
