<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Designates the office category within an organization. | The effective and expiry dates for this organization membership. | Allows for control of the sharing of organization data between parties. | Indicates whether the organization
 * is the default choice among several. | Membership organization that has travel benefits, programs, or discounts.
 * @subpackage Structs
 */
class OrganizationType extends AbstractStructBase
{
    /**
     * The OrgMemberName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrgMemberName
     */
    public $OrgMemberName;
    /**
     * The OrgName
     * Meta information extracted from the WSDL
     * - documentation: Name of the organization.
     * - minOccurs: 0
     * @var mixed
     */
    public $OrgName;
    /**
     * The RelatedOrgName
     * Meta information extracted from the WSDL
     * - documentation: An organization that is related to this organization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RelatedOrgName;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - documentation: Information on the company responsible for arranging travel for the organization.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TravelArranger;
    /**
     * Constructor method for OrganizationType
     * @uses OrganizationType::setOrgMemberName()
     * @uses OrganizationType::setOrgName()
     * @uses OrganizationType::setRelatedOrgName()
     * @uses OrganizationType::setTravelArranger()
     * @param \StructType\OrgMemberName $orgMemberName
     * @param mixed $orgName
     * @param mixed[] $relatedOrgName
     * @param mixed[] $travelArranger
     */
    public function __construct(\StructType\OrgMemberName $orgMemberName = null, $orgName = null, array $relatedOrgName = array(), array $travelArranger = array())
    {
        $this
            ->setOrgMemberName($orgMemberName)
            ->setOrgName($orgName)
            ->setRelatedOrgName($relatedOrgName)
            ->setTravelArranger($travelArranger);
    }
    /**
     * Get OrgMemberName value
     * @return \StructType\OrgMemberName|null
     */
    public function getOrgMemberName()
    {
        return $this->OrgMemberName;
    }
    /**
     * Set OrgMemberName value
     * @param \StructType\OrgMemberName $orgMemberName
     * @return \StructType\OrganizationType
     */
    public function setOrgMemberName(\StructType\OrgMemberName $orgMemberName = null)
    {
        $this->OrgMemberName = $orgMemberName;
        return $this;
    }
    /**
     * Get OrgName value
     * @return mixed|null
     */
    public function getOrgName()
    {
        return $this->OrgName;
    }
    /**
     * Set OrgName value
     * @param mixed $orgName
     * @return \StructType\OrganizationType
     */
    public function setOrgName($orgName = null)
    {
        $this->OrgName = $orgName;
        return $this;
    }
    /**
     * Get RelatedOrgName value
     * @return mixed[]|null
     */
    public function getRelatedOrgName()
    {
        return $this->RelatedOrgName;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedOrgName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedOrgName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedOrgNameForArrayConstraintsFromSetRelatedOrgName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organizationTypeRelatedOrgNameItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($organizationTypeRelatedOrgNameItem) ? get_class($organizationTypeRelatedOrgNameItem) : sprintf('%s(%s)', gettype($organizationTypeRelatedOrgNameItem), var_export($organizationTypeRelatedOrgNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedOrgName property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param mixed[] $relatedOrgName
     * @return \StructType\OrganizationType
     */
    public function setRelatedOrgName(array $relatedOrgName = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedOrgNameArrayErrorMessage = self::validateRelatedOrgNameForArrayConstraintsFromSetRelatedOrgName($relatedOrgName))) {
            throw new \InvalidArgumentException($relatedOrgNameArrayErrorMessage, __LINE__);
        }
        $this->RelatedOrgName = $relatedOrgName;
        return $this;
    }
    /**
     * Add item to RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OrganizationType
     */
    public function addToRelatedOrgName($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedOrgName[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return mixed[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organizationTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($organizationTypeTravelArrangerItem) ? get_class($organizationTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($organizationTypeTravelArrangerItem), var_export($organizationTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed[] $travelArranger
     * @return \StructType\OrganizationType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\OrganizationType
     */
    public function addToTravelArranger($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrganizationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
