<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationTime StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides operating times of a facility. | The date span applicable to the operation. | The day(s) of week to which the operation time applies.
 * @subpackage Structs
 */
class OperationTime extends AbstractStructBase
{
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - documentation: Example: After hours operations | Additional operation information.
     * - minOccurs: 0
     * @var mixed
     */
    public $AdditionalInfo;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - documentation: Example: On the half hour | Frequency description. | The frequency with which this operation occurs (e.g., 'on the hour', 'on the half hour').
     * - use: optional
     * @var string
     */
    public $Frequency;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Period of operation description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Mon
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Monday. | Example: true | Monday available indicator. | When true, apply to Monday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Tuesday. | Example: true | Tuesday available indicator. | When true, apply to Tuesday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Wednesday. | Example: true | Wednesday available indicator. | When true, apply to Wednesday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Thursday. | Example: true | Thursday available indicator. | When true, apply to Thursday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Friday. | Example: true | Friday available indicator. | When true, apply to Friday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Saturday. | Example: true | Saturday available indicator. | When true, apply to Saturday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * Meta information extracted from the WSDL
     * - documentation: If true, apply to Sunday. | Example: true | Sunday available indicator. | When true, apply to Sunday.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $Sun;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: Operation start period. | The starting value of the time span.
     * - type: DateOrTimeOrDateTimeType
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Example: P2D | Period duration. | The duration datatype represents a combination of year, month, day and time values representing a single duration of time, encoded as a single string.
     * - type: DurationType
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: Operation end period. | The ending value of the time span.
     * - type: DateOrTimeOrDateTimeType
     * - use: optional
     * @var string
     */
    public $End;
    /**
     * The AdditionalOperationInfoCode
     * Meta information extracted from the WSDL
     * - documentation: Used to provide additional information regarding operation times (e.g., after hours operations, restricted times). Refer to OpenTravel Code List Additional Operation Info (OPR).
     * - use: optional
     * @var string
     */
    public $AdditionalOperationInfoCode;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Textual information for this period of operation.
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * Constructor method for OperationTime
     * @uses OperationTime::setAdditionalInfo()
     * @uses OperationTime::setFrequency()
     * @uses OperationTime::setDescription()
     * @uses OperationTime::setMon()
     * @uses OperationTime::setTue()
     * @uses OperationTime::setWeds()
     * @uses OperationTime::setThur()
     * @uses OperationTime::setFri()
     * @uses OperationTime::setSat()
     * @uses OperationTime::setSun()
     * @uses OperationTime::setStart()
     * @uses OperationTime::setDuration()
     * @uses OperationTime::setEnd()
     * @uses OperationTime::setAdditionalOperationInfoCode()
     * @uses OperationTime::setText()
     * @param mixed $additionalInfo
     * @param string $frequency
     * @param string $description
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $additionalOperationInfoCode
     * @param string $text
     */
    public function __construct($additionalInfo = null, $frequency = null, $description = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null, $start = null, $duration = null, $end = null, $additionalOperationInfoCode = null, $text = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setFrequency($frequency)
            ->setDescription($description)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setAdditionalOperationInfoCode($additionalOperationInfoCode)
            ->setText($text);
    }
    /**
     * Get AdditionalInfo value
     * @return mixed|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param mixed $additionalInfo
     * @return \StructType\OperationTime
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\OperationTime
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\OperationTime
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\OperationTime
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\OperationTime
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\OperationTime
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\OperationTime
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\OperationTime
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\OperationTime
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\OperationTime
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\OperationTime
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\OperationTime
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\OperationTime
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get AdditionalOperationInfoCode value
     * @return string|null
     */
    public function getAdditionalOperationInfoCode()
    {
        return $this->AdditionalOperationInfoCode;
    }
    /**
     * Set AdditionalOperationInfoCode value
     * @param string $additionalOperationInfoCode
     * @return \StructType\OperationTime
     */
    public function setAdditionalOperationInfoCode($additionalOperationInfoCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalOperationInfoCode) && !is_string($additionalOperationInfoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalOperationInfoCode, true), gettype($additionalOperationInfoCode)), __LINE__);
        }
        $this->AdditionalOperationInfoCode = $additionalOperationInfoCode;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\OperationTime
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
