<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingAirlineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the operating carrier and flight number.
 * @subpackage Structs
 */
class OperatingAirlineType extends CompanyNameType
{
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The flight number as assigned by the operating carrier.
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The reservation booking designator of the operating carrier when different from the marketing carrier.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The MarketingInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the information pertains to the marketing flight. If false, the information pertains to the operating flight.
     * - use: optional
     * @var bool
     */
    public $MarketingInd;
    /**
     * The BookedRBD
     * Meta information extracted from the WSDL
     * - documentation: Identifies the Booked RBD. This may be different than the ticket class. RBD stands for reservation booking designator.
     * - use: optional
     * @var string
     */
    public $BookedRBD;
    /**
     * The TicketedRBD
     * Meta information extracted from the WSDL
     * - documentation: Identifies the ticketed RBD. This may be different than the ticket class. RBD stands for reservation booking designator.
     * - use: optional
     * @var string
     */
    public $TicketedRBD;
    /**
     * The FrequentFlierMiles
     * Meta information extracted from the WSDL
     * - documentation: Standard mileage that can be accrued for this flight (if flown by the passenger). This does not include bonus miles.
     * - use: optional
     * @var string
     */
    public $FrequentFlierMiles;
    /**
     * Constructor method for OperatingAirlineType
     * @uses OperatingAirlineType::setFlightNumber()
     * @uses OperatingAirlineType::setResBookDesigCode()
     * @uses OperatingAirlineType::setMarketingInd()
     * @uses OperatingAirlineType::setBookedRBD()
     * @uses OperatingAirlineType::setTicketedRBD()
     * @uses OperatingAirlineType::setFrequentFlierMiles()
     * @param string $flightNumber
     * @param string $resBookDesigCode
     * @param bool $marketingInd
     * @param string $bookedRBD
     * @param string $ticketedRBD
     * @param string $frequentFlierMiles
     */
    public function __construct($flightNumber = null, $resBookDesigCode = null, $marketingInd = null, $bookedRBD = null, $ticketedRBD = null, $frequentFlierMiles = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode)
            ->setMarketingInd($marketingInd)
            ->setBookedRBD($bookedRBD)
            ->setTicketedRBD($ticketedRBD)
            ->setFrequentFlierMiles($frequentFlierMiles);
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\OperatingAirlineType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\OperatingAirlineType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get MarketingInd value
     * @return bool|null
     */
    public function getMarketingInd()
    {
        return $this->MarketingInd;
    }
    /**
     * Set MarketingInd value
     * @param bool $marketingInd
     * @return \StructType\OperatingAirlineType
     */
    public function setMarketingInd($marketingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketingInd) && !is_bool($marketingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketingInd, true), gettype($marketingInd)), __LINE__);
        }
        $this->MarketingInd = $marketingInd;
        return $this;
    }
    /**
     * Get BookedRBD value
     * @return string|null
     */
    public function getBookedRBD()
    {
        return $this->BookedRBD;
    }
    /**
     * Set BookedRBD value
     * @param string $bookedRBD
     * @return \StructType\OperatingAirlineType
     */
    public function setBookedRBD($bookedRBD = null)
    {
        // validation for constraint: string
        if (!is_null($bookedRBD) && !is_string($bookedRBD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookedRBD, true), gettype($bookedRBD)), __LINE__);
        }
        $this->BookedRBD = $bookedRBD;
        return $this;
    }
    /**
     * Get TicketedRBD value
     * @return string|null
     */
    public function getTicketedRBD()
    {
        return $this->TicketedRBD;
    }
    /**
     * Set TicketedRBD value
     * @param string $ticketedRBD
     * @return \StructType\OperatingAirlineType
     */
    public function setTicketedRBD($ticketedRBD = null)
    {
        // validation for constraint: string
        if (!is_null($ticketedRBD) && !is_string($ticketedRBD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketedRBD, true), gettype($ticketedRBD)), __LINE__);
        }
        $this->TicketedRBD = $ticketedRBD;
        return $this;
    }
    /**
     * Get FrequentFlierMiles value
     * @return string|null
     */
    public function getFrequentFlierMiles()
    {
        return $this->FrequentFlierMiles;
    }
    /**
     * Set FrequentFlierMiles value
     * @param string $frequentFlierMiles
     * @return \StructType\OperatingAirlineType
     */
    public function setFrequentFlierMiles($frequentFlierMiles = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlierMiles) && !is_string($frequentFlierMiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlierMiles, true), gettype($frequentFlierMiles)), __LINE__);
        }
        $this->FrequentFlierMiles = $frequentFlierMiles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperatingAirlineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
